/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.converters.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.api.process.model.BPMNActivity;
import org.activiti.api.process.model.BPMNError;
import org.activiti.api.process.model.BPMNMessage;
import org.activiti.api.process.model.BPMNSequenceFlow;
import org.activiti.api.process.model.BPMNSignal;
import org.activiti.api.process.model.BPMNTimer;
import org.activiti.api.process.model.Deployment;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.process.model.MessageSubscription;
import org.activiti.api.process.model.ProcessDefinition;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.runtime.model.impl.BPMNActivityImpl;
import org.activiti.api.runtime.model.impl.BPMNErrorImpl;
import org.activiti.api.runtime.model.impl.BPMNMessageImpl;
import org.activiti.api.runtime.model.impl.BPMNSequenceFlowImpl;
import org.activiti.api.runtime.model.impl.BPMNSignalImpl;
import org.activiti.api.runtime.model.impl.BPMNTimerImpl;
import org.activiti.api.runtime.model.impl.DeploymentImpl;
import org.activiti.api.runtime.model.impl.IntegrationContextImpl;
import org.activiti.api.runtime.model.impl.MessageSubscriptionImpl;
import org.activiti.api.runtime.model.impl.ProcessDefinitionImpl;
import org.activiti.api.runtime.model.impl.ProcessInstanceImpl;
import org.activiti.api.runtime.model.impl.VariableInstanceImpl;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.impl.TaskImpl;
import org.activiti.cloud.api.process.model.IncidentContext;
import org.activiti.cloud.api.process.model.impl.IncidentContextImpl;
import org.activiti.cloud.services.audit.api.AuditException;

public class JpaJsonConverter<T>
implements AttributeConverter<T, String> {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private Class<T> entityClass;

    public JpaJsonConverter(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public String convertToDatabaseColumn(T entity) {
        try {
            return objectMapper.writeValueAsString(entity);
        }
        catch (JsonProcessingException e) {
            throw new AuditException("Unable to serialize object.", e);
        }
    }

    public T convertToEntityAttribute(String entityTextRepresentation) {
        try {
            if (entityTextRepresentation != null && entityTextRepresentation.length() > 0) {
                return (T)objectMapper.readValue(entityTextRepresentation, this.entityClass);
            }
            return null;
        }
        catch (IOException e) {
            throw new AuditException("Unable to deserialize object.", e);
        }
    }

    static {
        SimpleModule module = new SimpleModule("mapCommonModelInterfaces", Version.unknownVersion());
        SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver(){

            public JavaType resolveAbstractType(DeserializationConfig config, BeanDescription typeDesc) {
                return this.findTypeMapping(config, typeDesc.getType());
            }
        };
        resolver.addMapping(ProcessDefinition.class, ProcessDefinitionImpl.class);
        resolver.addMapping(VariableInstance.class, VariableInstanceImpl.class);
        resolver.addMapping(ProcessInstance.class, ProcessInstanceImpl.class);
        resolver.addMapping(Task.class, TaskImpl.class);
        resolver.addMapping(BPMNActivity.class, BPMNActivityImpl.class);
        resolver.addMapping(BPMNSequenceFlow.class, BPMNSequenceFlowImpl.class);
        resolver.addMapping(BPMNSignal.class, BPMNSignalImpl.class);
        resolver.addMapping(BPMNTimer.class, BPMNTimerImpl.class);
        resolver.addMapping(BPMNError.class, BPMNErrorImpl.class);
        resolver.addMapping(BPMNMessage.class, BPMNMessageImpl.class);
        resolver.addMapping(MessageSubscription.class, MessageSubscriptionImpl.class);
        resolver.addMapping(IntegrationContext.class, IntegrationContextImpl.class);
        resolver.addMapping(IncidentContext.class, IncidentContextImpl.class);
        resolver.addMapping(Deployment.class, DeploymentImpl.class);
        module.setAbstractTypes(resolver);
        objectMapper.registerModule((Module)module);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

