/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import org.activiti.api.task.model.TaskCandidateGroup;
import org.activiti.api.task.model.impl.TaskCandidateGroupImpl;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateGroupRemovedEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.TaskCandidateGroupJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

@Entity(name="TaskCandidateGroupRemovedEvent")
@DiscriminatorValue(value="TaskCandidateGroupRemovedEvent")
public class TaskCandidateGroupRemovedEventEntity
extends AuditEventEntity {
    protected static final String TASK_CANDIDATE_GROUP_REMOVED_EVENT = "TaskCandidateGroupRemovedEvent";
    @Convert(converter=TaskCandidateGroupJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private TaskCandidateGroupImpl candidateGroup;

    public TaskCandidateGroupRemovedEventEntity() {
    }

    public TaskCandidateGroupRemovedEventEntity(CloudTaskCandidateGroupRemovedEvent cloudEvent) {
        super((CloudRuntimeEvent<?, ?>)cloudEvent);
        this.setCandidateGroup((TaskCandidateGroup)cloudEvent.getEntity());
    }

    public TaskCandidateGroup getCandidateGroup() {
        return this.candidateGroup;
    }

    public void setCandidateGroup(TaskCandidateGroup candidateGroup) {
        this.candidateGroup = new TaskCandidateGroupImpl(candidateGroup.getGroupId(), candidateGroup.getTaskId());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskCandidateGroupRemovedEventEntity [candidateGroup=").append(this.candidateGroup).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

