/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.converters;

import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.services.audit.api.converters.EventToEntityConverter;
import org.activiti.cloud.services.audit.jpa.converters.EventContextInfoAppender;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

public abstract class BaseEventToEntityConverter
implements EventToEntityConverter<AuditEventEntity> {
    private EventContextInfoAppender eventContextInfoAppender;

    protected BaseEventToEntityConverter(EventContextInfoAppender eventContextInfoAppender) {
        this.eventContextInfoAppender = eventContextInfoAppender;
    }

    @Override
    public AuditEventEntity convertToEntity(CloudRuntimeEvent cloudRuntimeEvent) {
        return this.createEventEntity(cloudRuntimeEvent);
    }

    protected abstract AuditEventEntity createEventEntity(CloudRuntimeEvent var1);

    @Override
    public CloudRuntimeEvent convertToAPI(AuditEventEntity auditEventEntity) {
        CloudRuntimeEventImpl<?, ?> apiEvent = this.createAPIEvent(auditEventEntity);
        apiEvent.setAppName(auditEventEntity.getAppName());
        apiEvent.setAppVersion(auditEventEntity.getAppVersion());
        apiEvent.setServiceFullName(auditEventEntity.getServiceFullName());
        apiEvent.setServiceName(auditEventEntity.getServiceName());
        apiEvent.setServiceType(auditEventEntity.getServiceType());
        apiEvent.setServiceVersion(auditEventEntity.getServiceVersion());
        apiEvent.setMessageId(auditEventEntity.getMessageId());
        apiEvent.setSequenceNumber(Integer.valueOf(auditEventEntity.getSequenceNumber()));
        return this.eventContextInfoAppender.addProcessContextInfoToApiEvent(apiEvent, auditEventEntity);
    }

    protected abstract CloudRuntimeEventImpl<?, ?> createAPIEvent(AuditEventEntity var1);
}

