/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import org.activiti.api.task.model.TaskCandidateUser;
import org.activiti.api.task.model.impl.TaskCandidateUserImpl;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateUserRemovedEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.TaskCandidateUserJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

@Entity(name="TaskCandidateUserRemovedEvent")
@DiscriminatorValue(value="TaskCandidateUserRemovedEvent")
public class TaskCandidateUserRemovedEventEntity
extends AuditEventEntity {
    protected static final String TASK_CANDIDATE_USER_REMOVED_EVENT = "TaskCandidateUserRemovedEvent";
    @Convert(converter=TaskCandidateUserJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private TaskCandidateUserImpl candidateUser;

    public TaskCandidateUserRemovedEventEntity() {
    }

    public TaskCandidateUserRemovedEventEntity(CloudTaskCandidateUserRemovedEvent cloudEvent) {
        super((CloudRuntimeEvent<?, ?>)cloudEvent);
        this.setCandidateUser((TaskCandidateUser)cloudEvent.getEntity());
    }

    public TaskCandidateUser getCandidateUser() {
        return this.candidateUser;
    }

    public void setCandidateUser(TaskCandidateUser candidateUser) {
        this.candidateUser = new TaskCandidateUserImpl(candidateUser.getUserId(), candidateUser.getTaskId());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskCandidateUserRemovedEventEntity [candidateUser=").append(this.candidateUser).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

