/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.SequenceGenerator;
import java.util.Objects;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.hibernate.annotations.Immutable;

@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="TYPE")
@Entity(name="AuditEvent")
@Immutable
public abstract class AuditEventEntity {
    @Id
    @GeneratedValue(generator="audit_sequence", strategy=GenerationType.SEQUENCE)
    @SequenceGenerator(name="audit_sequence", sequenceName="audit_sequence", allocationSize=50)
    private Long id;
    private String eventId;
    private Long timestamp;
    private String eventType;
    private String appName;
    private String appVersion;
    private String serviceName;
    private String serviceFullName;
    private String serviceType;
    private String serviceVersion;
    private int sequenceNumber;
    private String messageId;
    private String entityId;
    private String processDefinitionId;
    private String processInstanceId;
    private String processDefinitionKey;
    private String parentProcessInstanceId;
    private String businessKey;

    public AuditEventEntity() {
    }

    public AuditEventEntity(CloudRuntimeEvent<?, ?> cloudEvent) {
        this.eventId = cloudEvent.getId();
        this.timestamp = cloudEvent.getTimestamp();
        this.eventType = cloudEvent.getEventType().name();
        this.appName = cloudEvent.getAppName();
        this.appVersion = cloudEvent.getAppVersion();
        this.serviceName = cloudEvent.getServiceName();
        this.serviceFullName = cloudEvent.getServiceFullName();
        this.serviceType = cloudEvent.getServiceType();
        this.serviceVersion = cloudEvent.getServiceVersion();
        this.messageId = cloudEvent.getMessageId();
        this.sequenceNumber = cloudEvent.getSequenceNumber();
        this.entityId = cloudEvent.getEntityId();
        this.processInstanceId = cloudEvent.getProcessInstanceId();
        this.processDefinitionId = cloudEvent.getProcessDefinitionId();
        this.processDefinitionKey = cloudEvent.getProcessDefinitionKey();
        this.businessKey = cloudEvent.getBusinessKey();
        this.parentProcessInstanceId = cloudEvent.getParentProcessInstanceId();
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getEventType() {
        return this.eventType;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceFullName() {
        return this.serviceFullName;
    }

    public void setServiceFullName(String serviceFullName) {
        this.serviceFullName = serviceFullName;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(String parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequeceNumber) {
        this.sequenceNumber = sequeceNumber;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuditEventEntity other = (AuditEventEntity)obj;
        return this.id != null && Objects.equals(this.id, other.id);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuditEventEntity [id=").append(this.id).append(", eventId=").append(this.eventId).append(", timestamp=").append(this.timestamp).append(", eventType=").append(this.eventType).append(", appName=").append(this.appName).append(", appVersion=").append(this.appVersion).append(", serviceName=").append(this.serviceName).append(", serviceFullName=").append(this.serviceFullName).append(", serviceType=").append(this.serviceType).append(", serviceVersion=").append(this.serviceVersion).append(", sequenceNumber=").append(this.sequenceNumber).append(", messageId=").append(this.messageId).append(", entityId=").append(this.entityId).append(", processDefinitionId=").append(this.processDefinitionId).append(", processInstanceId=").append(this.processInstanceId).append(", processDefinitionKey=").append(this.processDefinitionKey).append(", parentProcessInstanceId=").append(this.parentProcessInstanceId).append(", businessKey=").append(this.businessKey).append("]");
        return builder.toString();
    }
}

