/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class FunctionBindingPropertySource
extends PropertySource {
    public static final String SPRING_CLOUD_FUNCTION_DEFINITION = "spring.cloud.function.definition";
    private Set<String> functions = new LinkedHashSet<String>();
    private final String definition;

    public FunctionBindingPropertySource(ConfigurableEnvironment environment) {
        super(FunctionBindingPropertySource.class.getSimpleName());
        this.definition = environment.getProperty(SPRING_CLOUD_FUNCTION_DEFINITION, "");
        environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)this);
    }

    public void register(String name) {
        this.functions.add(name);
    }

    public Object getProperty(String name) {
        if (!SPRING_CLOUD_FUNCTION_DEFINITION.equals(name)) {
            return null;
        }
        return Stream.concat(Stream.of(this.definition.split(";")).filter(StringUtils::hasText), this.functions.stream().filter(StringUtils::hasText)).distinct().collect(Collectors.joining(";"));
    }
}

