/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompletableFutureRetry {
    private static final Logger log = LoggerFactory.getLogger(CompletableFutureRetry.class);
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    CompletableFutureRetry() {
    }

    public static <T> CompletableFuture<T> supplyAsyncWithRetry(Supplier<CompletableFuture<T>> supplier, int maxRetries) {
        return CompletableFutureRetry.supplyAsyncWithRetry(supplier, maxRetries, Duration.ZERO);
    }

    public static <T> CompletableFuture<T> supplyAsyncWithRetry(Supplier<CompletableFuture<T>> supplier, int maxRetries, Duration delay) {
        return CompletableFutureRetry.supplyAsyncWithRetry(supplier, maxRetries, delay, 0);
    }

    private static <T> CompletableFuture<T> supplyAsyncWithRetry(Supplier<CompletableFuture<T>> supplier, int maxRetries, Duration delay, int currentAttempt) {
        return supplier.get().exceptionallyCompose(exception -> {
            if (currentAttempt < maxRetries) {
                log.debug("Attempt {} of {} failed. Retrying in {}", new Object[]{currentAttempt + 1, maxRetries, delay});
                return CompletableFuture.supplyAsync(() -> null, scheduler).thenCompose(arg_0 -> CompletableFutureRetry.lambda$supplyAsyncWithRetry$1((Supplier)supplier, maxRetries, delay, currentAttempt, arg_0));
            }
            log.debug("Maximum of {} retries reached. Failing operation.", (Object)maxRetries, exception);
            return CompletableFuture.failedFuture(exception);
        });
    }

    private static /* synthetic */ CompletionStage lambda$supplyAsyncWithRetry$1(Supplier supplier, int maxRetries, Duration delay, int currentAttempt, Object ignored) {
        return CompletableFutureRetry.supplyAsyncWithRetry(supplier, maxRetries, delay, currentAttempt + 1);
    }
}

