/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.liquibase;

import java.util.Collections;
import java.util.Objects;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public abstract class SpringLiquibaseConfigurationSupport
implements ResourceLoaderAware {
    private ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected SpringLiquibase buildSpringLiquibase(DataSource dataSource, LiquibaseProperties properties) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setDataSource(dataSource);
        liquibase.setResourceLoader(this.resourceLoader);
        liquibase.setChangeLog(properties.getChangeLog());
        liquibase.setContexts(String.join((CharSequence)",", Objects.requireNonNullElse(properties.getContexts(), Collections.emptyList())));
        liquibase.setDefaultSchema(properties.getDefaultSchema());
        liquibase.setLiquibaseTablespace(properties.getLiquibaseTablespace());
        liquibase.setDropFirst(properties.isDropFirst());
        liquibase.setShouldRun(properties.isEnabled());
        liquibase.setLabelFilter(String.join((CharSequence)",", Objects.requireNonNullElse(properties.getLabelFilter(), Collections.emptyList())));
        liquibase.setChangeLogParameters(properties.getParameters());
        liquibase.setRollbackFile(properties.getRollbackFile());
        liquibase.setDatabaseChangeLogTable(properties.getDatabaseChangeLogTable());
        liquibase.setDatabaseChangeLogLockTable(properties.getDatabaseChangeLogLockTable());
        liquibase.setTestRollbackOnUpdate(properties.isTestRollbackOnUpdate());
        return liquibase;
    }
}

