/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.acc.shared.rest;

import feign.Headers;
import feign.RequestLine;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.gson.GsonEncoder;
import net.serenitybdd.core.Serenity;
import org.activiti.cloud.acc.shared.rest.feign.FeignRestDataClient;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;

public class DirtyContextHandler {
    private static final String DIRTY_CONTEXT = "dirtyContext";
    private static final String DIRTY_CONTEXT_DELIMITER = ";";

    public <M> EntityModel<M> dirty(EntityModel<M> resource) {
        this.dirty(((Link)resource.getLink(IanaLinkRelations.SELF).get()).getHref());
        return resource;
    }

    public String dirtyRelation(String parentUri, String childUri) {
        return this.dirty(parentUri + childUri.substring(childUri.lastIndexOf(47)));
    }

    public String dirty(String uri) {
        Serenity.setSessionVariable((Object)DIRTY_CONTEXT).to((Object)(Serenity.hasASessionVariableCalled((Object)DIRTY_CONTEXT) ? String.join((CharSequence)DIRTY_CONTEXT_DELIMITER, uri, (CharSequence)Serenity.sessionVariableCalled((Object)DIRTY_CONTEXT)) : uri));
        return uri;
    }

    public void cleanup() {
        if (Serenity.hasASessionVariableCalled((Object)DIRTY_CONTEXT)) {
            String dirtyContext = (String)Serenity.sessionVariableCalled((Object)DIRTY_CONTEXT);
            String[] dirtyUris = dirtyContext.split(DIRTY_CONTEXT_DELIMITER);
            Serenity.setSessionVariable((Object)DIRTY_CONTEXT).to(null);
            for (String uri : dirtyUris) {
                try {
                    this.deleteByUri(uri);
                }
                catch (Exception ex) {
                    this.dirty(uri);
                }
            }
        }
    }

    public void deleteByUri(String uri) {
        ((DeleteByUriClient)FeignRestDataClient.builder((Encoder)new GsonEncoder(), (Decoder)new Decoder.Default()).target(DeleteByUriClient.class, uri)).delete();
    }

    private static interface DeleteByUriClient {
        @RequestLine(value="DELETE")
        @Headers(value={"Content-Type: application/json"})
        public void delete();
    }
}

