/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.acc.shared.serenity;

import java.lang.reflect.Method;
import java.util.Map;
import net.thucydides.core.steps.StepEventBus;
import org.activiti.cloud.acc.shared.rest.error.ExpectRestError;
import org.activiti.cloud.acc.shared.rest.error.ExpectRestNotFound;
import org.activiti.cloud.acc.shared.rest.error.ExpectedRestException;
import org.activiti.cloud.acc.shared.serenity.exception.ExpectException;
import org.activiti.cloud.acc.shared.serenity.exception.ExpectedException;
import org.activiti.cloud.acc.shared.serenity.exception.ExpectedExceptionHandler;
import org.activiti.cloud.acc.shared.serenity.exception.ExpectedExceptionNotThrown;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.steps.AbstractStepResult;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepResult;
import org.jbehave.core.steps.Timer;
import org.jbehave.core.steps.context.StepsContext;

public class ExtendedStepCreator
extends StepCreator {
    private Keywords keywords;

    public ExtendedStepCreator(Class<?> stepsType, InjectableStepsFactory stepsFactory, StepsContext stepsContext, ParameterConverters parameterConverters, ParameterControls parameterControls, StepMatcher stepMatcher, StepMonitor stepMonitor, Keywords keywords) {
        super(stepsType, stepsFactory, stepsContext, parameterConverters, parameterControls, stepMatcher, stepMonitor);
        this.keywords = keywords;
    }

    public Step createParametrisedStep(Method method, String stepAsString, String stepWithoutStartingWord, Map<String, String> namedParameters) {
        ExpectedException expectedException = this.getExpectedException(method);
        return expectedException != null ? new ExpectingExceptionParametrisedStep(this, stepAsString, method, stepWithoutStartingWord, namedParameters, this.getKeywords(), expectedException) : super.createParametrisedStep(method, stepAsString, stepWithoutStartingWord, namedParameters);
    }

    protected ExpectedException getExpectedException(Method method) {
        ExpectRestNotFound expectRestNotFound;
        ExpectRestError expectRestError;
        ExpectedException expectedException = null;
        ExpectException expectException = method.getAnnotation(ExpectException.class);
        if (expectException != null) {
            expectedException = new ExpectedException(expectException.value());
        }
        if ((expectRestError = method.getAnnotation(ExpectRestError.class)) != null) {
            expectedException = new ExpectedRestException(expectRestError.statusCode(), expectRestError.value());
        }
        if ((expectRestNotFound = method.getAnnotation(ExpectRestNotFound.class)) != null) {
            expectedException = new ExpectedRestException(expectRestNotFound.statusCode(), expectRestNotFound.value());
        }
        return expectedException;
    }

    public Keywords getKeywords() {
        return this.keywords;
    }

    class ExpectingExceptionParametrisedStep
    extends StepCreator.ParametrisedStep {
        private String stepAsString;
        private Keywords keywords;
        private ExpectedException expectedException;

        public ExpectingExceptionParametrisedStep(ExtendedStepCreator this$0, String stepAsString, Method method, String stepWithoutStartingWord, Map<String, String> namedParameters, Keywords keywords, ExpectedException expectedException) {
            super((StepCreator)this$0, stepAsString, method, stepWithoutStartingWord, namedParameters);
            this.stepAsString = stepAsString;
            this.keywords = keywords;
            this.expectedException = expectedException;
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            if (this.expectedException == null) {
                return super.perform(storyFailureIfItHappened);
            }
            Timer timer = new Timer().start();
            boolean isExpectedExceptionThrown = ExpectedExceptionHandler.isThrowingExpectedException(this.expectedException, () -> this.performWithThrowing(storyFailureIfItHappened));
            if (!isExpectedExceptionThrown) {
                ExpectedExceptionNotThrown failureCause = new ExpectedExceptionNotThrown("The exception was not thrown as expected: " + String.valueOf(this.expectedException), this.expectedException);
                return AbstractStepResult.failed((String)this.stepAsString, (UUIDExceptionWrapper)new UUIDExceptionWrapper(this.stepAsString, (Throwable)failureCause)).withParameterValues(this.asString(this.keywords)).setTimings(timer.stop());
            }
            StepEventBus.getEventBus().getBaseStepListener().exceptionExpected(ExpectedException.class);
            return AbstractStepResult.successful((String)this.stepAsString).withParameterValues(this.asString(this.keywords)).setTimings(timer.stop());
        }

        protected void performWithThrowing(UUIDExceptionWrapper storyFailureIfItHappened) throws Throwable {
            StepResult result = super.perform(storyFailureIfItHappened);
            if (result.getFailure() != null) {
                throw result.getFailure().getCause();
            }
        }
    }
}

