/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.engine.impl.variable.EntityManagerSessionImpl;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

public class SpringEntityManagerSessionFactory
implements SessionFactory {
    protected EntityManagerFactory entityManagerFactory;
    protected boolean handleTransactions;
    protected boolean closeEntityManager;

    public SpringEntityManagerSessionFactory(Object entityManagerFactory, boolean handleTransactions, boolean closeEntityManager) {
        this.entityManagerFactory = (EntityManagerFactory)entityManagerFactory;
        this.handleTransactions = handleTransactions;
        this.closeEntityManager = closeEntityManager;
    }

    public Class<?> getSessionType() {
        return EntityManagerFactory.class;
    }

    public Session openSession(CommandContext commandContext) {
        EntityManager entityManager = EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory);
        if (entityManager == null) {
            return new EntityManagerSessionImpl(this.entityManagerFactory, this.handleTransactions, this.closeEntityManager);
        }
        return new EntityManagerSessionImpl(this.entityManagerFactory, entityManager, false, false);
    }
}

