/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.common.spring.security;

import java.security.Principal;
import java.util.List;
import java.util.Optional;
import org.activiti.api.runtime.shared.security.PrincipalGroupsProvider;
import org.activiti.core.common.spring.security.GrantedAuthoritiesGroupsMapper;
import org.activiti.core.common.spring.security.GrantedAuthoritiesResolver;
import org.springframework.lang.NonNull;

public class AuthenticationPrincipalGroupsProvider
implements PrincipalGroupsProvider {
    private final GrantedAuthoritiesResolver grantedAuthoritiesResolver;
    private final GrantedAuthoritiesGroupsMapper grantedAuthoritiesGroupsMapper;

    public AuthenticationPrincipalGroupsProvider(@NonNull GrantedAuthoritiesResolver grantedAuthoritiesResolver, @NonNull GrantedAuthoritiesGroupsMapper grantedAuthoritiesGroupsMapper) {
        this.grantedAuthoritiesResolver = grantedAuthoritiesResolver;
        this.grantedAuthoritiesGroupsMapper = grantedAuthoritiesGroupsMapper;
    }

    public List<String> getGroups(@NonNull Principal principal) {
        return Optional.of(principal).map(this.grantedAuthoritiesResolver::getAuthorities).map(this.grantedAuthoritiesGroupsMapper::getGroups).orElseThrow(this::securityException);
    }

    protected SecurityException securityException() {
        return new SecurityException("Invalid principal groups");
    }
}

