/*
 * Copyright 2010-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.spring.process.model;

import java.util.Objects;

public class TaskTemplateDefinition {

    private TemplateDefinition assignee;

    private TemplateDefinition candidate;

    private boolean isEmailNotificationEnabled = true;

    public TemplateDefinition getAssignee() {
        return assignee;
    }

    public boolean isEmailNotificationEnabled() {
        return isEmailNotificationEnabled;
    }

    public void setAssignee(TemplateDefinition assignee) {
        this.assignee = assignee;
    }

    public TemplateDefinition getCandidate() {
        return candidate;
    }

    public void setCandidate(TemplateDefinition candidate) {
        this.candidate = candidate;
    }

    public void setEmailNotificationEnabled(boolean emailNotificationEnabled) {
        this.isEmailNotificationEnabled = emailNotificationEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TaskTemplateDefinition that = (TaskTemplateDefinition) o;
        return (
            Objects.equals(assignee, that.assignee) &&
            Objects.equals(candidate, that.candidate) &&
            isEmailNotificationEnabled == that.isEmailNotificationEnabled
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(assignee, candidate, isEmailNotificationEnabled);
    }
}
