/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.spring.process.ProcessExtensionResourceReader;
import org.activiti.spring.process.model.Extension;
import org.activiti.spring.process.model.ProcessExtensionModel;
import org.activiti.spring.resources.DeploymentResourceLoader;
import org.activiti.spring.resources.ResourceReader;

public class ProcessExtensionService {
    private DeploymentResourceLoader<ProcessExtensionModel> processExtensionLoader;
    private ProcessExtensionResourceReader processExtensionReader;
    private RepositoryService repositoryService;
    private static final Extension EMPTY_EXTENSIONS = new Extension();
    private Map<String, Map<String, Extension>> processExtensionModelDeploymentMap = new HashMap<String, Map<String, Extension>>();

    public ProcessExtensionService(DeploymentResourceLoader<ProcessExtensionModel> processExtensionLoader, ProcessExtensionResourceReader processExtensionReader) {
        this.processExtensionLoader = processExtensionLoader;
        this.processExtensionReader = processExtensionReader;
    }

    private Map<String, Extension> getProcessExtensionsForDeploymentId(String deploymentId) {
        Map<String, Extension> processExtensionModelMap = this.processExtensionModelDeploymentMap.get(deploymentId);
        if (processExtensionModelMap != null) {
            return processExtensionModelMap;
        }
        List processExtensionModels = this.processExtensionLoader.loadResourcesForDeployment(deploymentId, (ResourceReader)this.processExtensionReader);
        processExtensionModelMap = this.buildProcessDefinitionAndExtensionMap(processExtensionModels);
        this.processExtensionModelDeploymentMap.put(deploymentId, processExtensionModelMap);
        return processExtensionModelMap;
    }

    private Map<String, Extension> buildProcessDefinitionAndExtensionMap(List<ProcessExtensionModel> processExtensionModels) {
        HashMap<String, Extension> buildProcessExtensionMap = new HashMap<String, Extension>();
        for (ProcessExtensionModel processExtensionModel : processExtensionModels) {
            buildProcessExtensionMap.putAll(processExtensionModel.getAllExtensions());
        }
        return buildProcessExtensionMap;
    }

    public boolean hasExtensionsFor(ProcessDefinition processDefinition) {
        return !EMPTY_EXTENSIONS.equals(this.getExtensionsFor(processDefinition));
    }

    public boolean hasExtensionsFor(String processDefinitionId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processDefinitionId);
        return this.hasExtensionsFor(processDefinition);
    }

    public Extension getExtensionsFor(ProcessDefinition processDefinition) {
        Map<String, Extension> processExtensionModelMap = this.getProcessExtensionsForDeploymentId(processDefinition.getDeploymentId());
        Extension extension = processExtensionModelMap.get(processDefinition.getKey());
        return extension != null ? extension : EMPTY_EXTENSIONS;
    }

    public Extension getExtensionsForId(String processDefinitionId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processDefinitionId);
        Extension processExtension = this.getExtensionsFor(processDefinition);
        return processExtension != null ? processExtension : EMPTY_EXTENSIONS;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

