/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.common.spring.connector;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.activiti.core.common.model.connector.ConnectorDefinition;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ConnectorDefinitionService {
    private String connectorRoot;
    private final ObjectMapper objectMapper;
    private ResourcePatternResolver resourceLoader;

    public ConnectorDefinitionService(String connectorRoot, ObjectMapper objectMapper, ResourcePatternResolver resourceLoader) {
        this.connectorRoot = connectorRoot;
        this.objectMapper = objectMapper;
        this.resourceLoader = resourceLoader;
    }

    private Optional<Resource[]> retrieveResources() throws IOException {
        Optional<Resource[]> resources = Optional.empty();
        Resource connectorRootPath = this.resourceLoader.getResource(this.connectorRoot);
        if (connectorRootPath.exists()) {
            return Optional.ofNullable(this.resourceLoader.getResources(this.connectorRoot + "**.json"));
        }
        return resources;
    }

    private ConnectorDefinition read(InputStream inputStream) throws IOException {
        return (ConnectorDefinition)this.objectMapper.readValue(inputStream, ConnectorDefinition.class);
    }

    public List<ConnectorDefinition> get() throws IOException {
        ArrayList<ConnectorDefinition> connectorDefinitions = new ArrayList<ConnectorDefinition>();
        Optional<Resource[]> resourcesOptional = this.retrieveResources();
        if (resourcesOptional.isPresent()) {
            for (Resource resource : resourcesOptional.get()) {
                connectorDefinitions.add(this.read(resource.getInputStream()));
            }
            this.validate(connectorDefinitions);
        }
        return connectorDefinitions;
    }

    protected void validate(List<ConnectorDefinition> connectorDefinitions) {
        if (!connectorDefinitions.isEmpty()) {
            HashSet<String> processedNames = new HashSet<String>();
            for (ConnectorDefinition connectorDefinition : connectorDefinitions) {
                String name = connectorDefinition.getName();
                if (name == null || name.isEmpty()) {
                    throw new IllegalStateException("connectorDefinition name cannot be null or empty");
                }
                if (name.contains(".")) {
                    throw new IllegalStateException("connectorDefinition name cannot have '.' character");
                }
                if (processedNames.add(name)) continue;
                throw new IllegalStateException("More than one connectorDefinition with name '" + name + "' was found. Names must be unique.");
            }
        }
    }
}

