/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.cache.config;

import java.util.HashMap;
import java.util.Map;
import org.activiti.spring.cache.ActivitiSpringCacheManagerProperties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ActivitiSpringCacheManagerEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    protected static final String ACTIVITI_SPRING_CACHE_MANAGER_PROVIDER_KEY = "activiti.spring.cache-manager.provider";
    protected static final String SPRING_CACHE_TYPE_KEY = "spring.cache.type";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ActivitiSpringCacheManagerProperties.CacheProvider cacheProvider = (ActivitiSpringCacheManagerProperties.CacheProvider)((Object)environment.getProperty(ACTIVITI_SPRING_CACHE_MANAGER_PROVIDER_KEY, ActivitiSpringCacheManagerProperties.CacheProvider.class, (Object)ActivitiSpringCacheManagerProperties.CacheProvider.caffeine));
        environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new MapPropertySource(this.getClass().getSimpleName(), this.resolvePropertiesToSet(cacheProvider)));
    }

    private Map<String, Object> resolvePropertiesToSet(ActivitiSpringCacheManagerProperties.CacheProvider messagingBroker) {
        HashMap<String, Object> extraProperties = new HashMap<String, Object>();
        extraProperties.put(SPRING_CACHE_TYPE_KEY, this.resolveCacheType(messagingBroker));
        return extraProperties;
    }

    private CacheType resolveCacheType(ActivitiSpringCacheManagerProperties.CacheProvider cacheProvider) {
        return switch (cacheProvider) {
            case ActivitiSpringCacheManagerProperties.CacheProvider.simple -> CacheType.SIMPLE;
            case ActivitiSpringCacheManagerProperties.CacheProvider.caffeine -> CacheType.CAFFEINE;
            default -> CacheType.NONE;
        };
    }
}

