/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.cache.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.activiti.spring.cache.ActivitiSpringCacheManagerProperties;
import org.activiti.spring.cache.caffeine.ActivitiSpringCaffeineCacheConfigurer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizer;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@AutoConfiguration(before={CacheAutoConfiguration.class})
@EnableCaching
@EnableConfigurationProperties(value={ActivitiSpringCacheManagerProperties.class})
@PropertySource(value={"classpath:config/activiti-spring-cache-manager.properties"})
public class ActivitiSpringCacheManagerAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"activiti.spring.cache-manager.provider"}, havingValue="noop")
    public InitializingBean activitiSpringNoopCacheManagerInitializer(ActivitiSpringCacheManagerProperties properties, CacheManager cacheManager) {
        return () -> properties.getCaches().entrySet().stream().filter(it -> ((ActivitiSpringCacheManagerProperties.ActivitiCacheProperties)it.getValue()).isEnabled()).map(Map.Entry::getKey).forEach(arg_0 -> ((CacheManager)cacheManager).getCache(arg_0));
    }

    @Bean
    @ConditionalOnProperty(value={"activiti.spring.cache-manager.provider"}, havingValue="simple")
    public CacheManagerCustomizer<ConcurrentMapCacheManager> activitiSpringSimpleCacheManagerCustomizer(ActivitiSpringCacheManagerProperties properties) {
        return cacheManager -> {
            ArrayList cacheNames = new ArrayList();
            ActivitiSpringCacheManagerProperties.SimpleCacheProviderProperties cacheProperties = properties.getSimple();
            cacheManager.setAllowNullValues(cacheProperties.isAllowNullValues());
            properties.getCaches().entrySet().stream().filter(it -> ((ActivitiSpringCacheManagerProperties.ActivitiCacheProperties)it.getValue()).isEnabled()).map(Map.Entry::getKey).forEach(cacheNames::add);
            cacheManager.setCacheNames(cacheNames);
        };
    }

    @Bean
    @ConditionalOnClass(value={CaffeineCacheManager.class})
    @ConditionalOnProperty(value={"activiti.spring.cache-manager.provider"}, havingValue="caffeine")
    public CacheManagerCustomizer<CaffeineCacheManager> activitiSpringCaffeineCacheManagerCustomizer(ActivitiSpringCacheManagerProperties properties, ObjectProvider<ActivitiSpringCaffeineCacheConfigurer> cacheConfigurers) {
        return cacheManager -> {
            ActivitiSpringCacheManagerProperties.CaffeineCacheProviderProperties caffeineCacheProperties = properties.getCaffeine();
            cacheManager.setCaffeineSpec(CaffeineSpec.parse((String)caffeineCacheProperties.getDefaultSpec()));
            cacheManager.setAllowNullValues(caffeineCacheProperties.isAllowNullValues());
            properties.getCaches().entrySet().stream().filter(it -> ((ActivitiSpringCacheManagerProperties.ActivitiCacheProperties)it.getValue()).isEnabled()).forEach(cacheEntry -> Optional.ofNullable((ActivitiSpringCacheManagerProperties.ActivitiCacheProperties)cacheEntry.getValue()).map(ActivitiSpringCacheManagerProperties.ActivitiCacheProperties::getCaffeine).map(CacheProperties.Caffeine::getSpec).or(() -> Optional.ofNullable(properties.getCaffeine().getDefaultSpec())).map(CaffeineSpec::parse).map(Caffeine::from).ifPresent(caffeine -> {
                if (caffeineCacheProperties.isUseSystemScheduler()) {
                    caffeine.scheduler(Scheduler.systemScheduler());
                }
                Cache cache = cacheConfigurers.orderedStream().filter(configurer -> configurer.test((String)cacheEntry.getKey())).findFirst().map(configurer -> (Cache)configurer.apply(caffeine)).orElseGet(() -> ((Caffeine)caffeine).build());
                cacheManager.registerCustomCache((String)cacheEntry.getKey(), cache);
            }));
        };
    }
}

