/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.api.model.shared.event.RuntimeEvent;
import org.activiti.api.process.model.Deployment;
import org.activiti.api.process.model.events.ApplicationDeployedEvent;
import org.activiti.api.process.model.events.ApplicationEvent;
import org.activiti.api.process.runtime.events.listener.ProcessRuntimeEventListener;
import org.activiti.api.runtime.event.impl.ApplicationDeployedEventImpl;
import org.activiti.api.runtime.event.impl.ApplicationDeployedEvents;
import org.activiti.api.runtime.model.impl.DeploymentImpl;
import org.activiti.engine.RepositoryService;
import org.activiti.runtime.api.model.impl.APIDeploymentConverter;
import org.activiti.spring.AbstractActivitiSmartLifeCycle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;

public class ApplicationDeployedEventProducer
extends AbstractActivitiSmartLifeCycle {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApplicationDeployedEventProducer.class);
    private static final String APPLICATION_DEPLOYMENT_NAME = "SpringAutoDeployment";
    private RepositoryService repositoryService;
    private APIDeploymentConverter deploymentConverter;
    private List<ProcessRuntimeEventListener<ApplicationDeployedEvent>> listeners;
    private ApplicationEventPublisher eventPublisher;
    @Value(value="${activiti.deploy.after-rollback:false}")
    private boolean afterRollback;

    public ApplicationDeployedEventProducer(RepositoryService repositoryService, APIDeploymentConverter deploymentConverter, List<ProcessRuntimeEventListener<ApplicationDeployedEvent>> listeners, ApplicationEventPublisher eventPublisher) {
        this.repositoryService = repositoryService;
        this.deploymentConverter = deploymentConverter;
        this.listeners = listeners;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void doStart() {
        List<ApplicationDeployedEvent> applicationDeployedEvents = this.getApplicationDeployedEvents();
        if (!applicationDeployedEvents.isEmpty()) {
            ApplicationDeployedEvent applicationDeployedEvent = applicationDeployedEvents.get(0);
            for (ProcessRuntimeEventListener<ApplicationDeployedEvent> listener : this.listeners) {
                listener.onEvent((RuntimeEvent)applicationDeployedEvent);
            }
            this.eventPublisher.publishEvent((Object)new ApplicationDeployedEvents(List.of(applicationDeployedEvent)));
        }
    }

    private List<ApplicationDeployedEvent> getApplicationDeployedEvents() {
        ApplicationEvent.ApplicationEvents eventType = this.getEventType();
        return this.deploymentConverter.from((Collection)this.repositoryService.createDeploymentQuery().deploymentName(APPLICATION_DEPLOYMENT_NAME).latestVersion().list()).stream().map(this::withProjectVersion1Based).map(deployment -> new ApplicationDeployedEventImpl(deployment, eventType)).collect(Collectors.toList());
    }

    private Deployment withProjectVersion1Based(Deployment deployment) {
        String projectReleaseVersion = deployment.getProjectReleaseVersion();
        if (StringUtils.isNumeric((CharSequence)projectReleaseVersion)) {
            DeploymentImpl result = new DeploymentImpl();
            result.setVersion(deployment.getVersion());
            result.setId(deployment.getId());
            result.setName(deployment.getName());
            int projectReleaseVersionInt = Integer.valueOf(projectReleaseVersion) + 1;
            result.setProjectReleaseVersion(String.valueOf(projectReleaseVersionInt));
            return result;
        }
        return deployment;
    }

    private ApplicationEvent.ApplicationEvents getEventType() {
        ApplicationEvent.ApplicationEvents eventType;
        if (this.afterRollback) {
            LOGGER.info("This pod has been marked as created after a rollback.");
            eventType = ApplicationEvent.ApplicationEvents.APPLICATION_ROLLBACK;
        } else {
            eventType = ApplicationEvent.ApplicationEvents.APPLICATION_DEPLOYED;
        }
        return eventType;
    }

    public void setAfterRollback(boolean afterRollback) {
        this.afterRollback = afterRollback;
    }

    @Override
    public void doStop() {
    }
}

