/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.activiti.api.model.shared.event.RuntimeEvent;
import org.activiti.api.process.model.ProcessCandidateStarterGroup;
import org.activiti.api.process.model.ProcessCandidateStarterUser;
import org.activiti.api.process.runtime.events.ProcessCandidateStarterGroupAddedEvent;
import org.activiti.api.process.runtime.events.ProcessCandidateStarterUserAddedEvent;
import org.activiti.api.process.runtime.events.listener.ProcessRuntimeEventListener;
import org.activiti.api.runtime.event.impl.ProcessCandidateStarterGroupAddedEventImpl;
import org.activiti.api.runtime.event.impl.ProcessCandidateStarterGroupAddedEvents;
import org.activiti.api.runtime.event.impl.ProcessCandidateStarterUserAddedEventImpl;
import org.activiti.api.runtime.event.impl.ProcessCandidateStarterUserAddedEvents;
import org.activiti.api.runtime.model.impl.ProcessCandidateStarterGroupImpl;
import org.activiti.api.runtime.model.impl.ProcessCandidateStarterUserImpl;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.IdentityLink;
import org.activiti.runtime.api.event.impl.ProcessCandidateStarterEventConverterHelper;
import org.activiti.spring.AbstractActivitiSmartLifeCycle;
import org.springframework.context.ApplicationEventPublisher;

public class ProcessCandidateStartersEventProducer
extends AbstractActivitiSmartLifeCycle {
    private RepositoryService repositoryService;
    private List<ProcessRuntimeEventListener<ProcessCandidateStarterUserAddedEvent>> candidateStarterUserListeners;
    private List<ProcessRuntimeEventListener<ProcessCandidateStarterGroupAddedEvent>> candidateStarterGroupListeners;
    private ProcessCandidateStarterEventConverterHelper processCandidateStarterEventConverterHelper = new ProcessCandidateStarterEventConverterHelper();
    private ApplicationEventPublisher eventPublisher;

    public ProcessCandidateStartersEventProducer(RepositoryService repositoryService, List<ProcessRuntimeEventListener<ProcessCandidateStarterUserAddedEvent>> candidateStarterUserListeners, List<ProcessRuntimeEventListener<ProcessCandidateStarterGroupAddedEvent>> candidateStarterGroupListeners, ApplicationEventPublisher eventPublisher) {
        this.repositoryService = repositoryService;
        this.candidateStarterUserListeners = Optional.ofNullable(candidateStarterUserListeners).orElseGet(() -> List.of());
        this.candidateStarterGroupListeners = Optional.ofNullable(candidateStarterGroupListeners).orElseGet(() -> List.of());
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void doStart() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().latestVersion().list();
        ArrayList<ProcessCandidateStarterUserAddedEvent> candidateStarterUserAddedEvents = new ArrayList<ProcessCandidateStarterUserAddedEvent>();
        ArrayList<ProcessCandidateStarterGroupAddedEvent> candidateStarterGroupAddedEvents = new ArrayList<ProcessCandidateStarterGroupAddedEvent>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            List identityLinks = this.repositoryService.getIdentityLinksForProcessDefinition(processDefinition.getId());
            for (IdentityLink identityLink : identityLinks) {
                if (this.processCandidateStarterEventConverterHelper.isProcessCandidateStarterUserLink(identityLink)) {
                    ProcessCandidateStarterUserAddedEvent processCandidateStarterUserAddedEvent = this.createCandidateStarterUserEvent(identityLink);
                    candidateStarterUserAddedEvents.add(processCandidateStarterUserAddedEvent);
                    this.notifyCandidateStarterUserAddedListeners(processCandidateStarterUserAddedEvent);
                    continue;
                }
                if (!this.processCandidateStarterEventConverterHelper.isProcessCandidateStarterGroupLink(identityLink)) continue;
                ProcessCandidateStarterGroupAddedEvent processCandidateStarterGroupAddedEvent = this.createCandidateStarterGroupEvent(identityLink);
                candidateStarterGroupAddedEvents.add(processCandidateStarterGroupAddedEvent);
                this.notifyCandidateStarterGroupAddedListeners(processCandidateStarterGroupAddedEvent);
            }
        }
        this.publishCandidateStarterEvents(candidateStarterUserAddedEvents, candidateStarterGroupAddedEvents);
    }

    private void notifyCandidateStarterUserAddedListeners(ProcessCandidateStarterUserAddedEvent processCandidateStarterUserAddedEvent) {
        for (ProcessRuntimeEventListener<ProcessCandidateStarterUserAddedEvent> listener : this.candidateStarterUserListeners) {
            listener.onEvent((RuntimeEvent)processCandidateStarterUserAddedEvent);
        }
    }

    private void notifyCandidateStarterGroupAddedListeners(ProcessCandidateStarterGroupAddedEvent processCandidateStarterGroupAddedEvent) {
        for (ProcessRuntimeEventListener<ProcessCandidateStarterGroupAddedEvent> listener : this.candidateStarterGroupListeners) {
            listener.onEvent((RuntimeEvent)processCandidateStarterGroupAddedEvent);
        }
    }

    private ProcessCandidateStarterUserAddedEvent createCandidateStarterUserEvent(IdentityLink identityLink) {
        return new ProcessCandidateStarterUserAddedEventImpl((ProcessCandidateStarterUser)new ProcessCandidateStarterUserImpl(identityLink.getProcessDefinitionId(), identityLink.getUserId()));
    }

    private ProcessCandidateStarterGroupAddedEvent createCandidateStarterGroupEvent(IdentityLink identityLink) {
        return new ProcessCandidateStarterGroupAddedEventImpl((ProcessCandidateStarterGroup)new ProcessCandidateStarterGroupImpl(identityLink.getProcessDefinitionId(), identityLink.getGroupId()));
    }

    private void publishCandidateStarterEvents(List<ProcessCandidateStarterUserAddedEvent> candidateStarterUserAddedEvents, List<ProcessCandidateStarterGroupAddedEvent> candidateStarterGroupAddedEvents) {
        if (!candidateStarterUserAddedEvents.isEmpty()) {
            this.eventPublisher.publishEvent((Object)new ProcessCandidateStarterUserAddedEvents(candidateStarterUserAddedEvents));
        }
        if (!candidateStarterGroupAddedEvents.isEmpty()) {
            this.eventPublisher.publishEvent((Object)new ProcessCandidateStarterGroupAddedEvents(candidateStarterGroupAddedEvents));
        }
    }

    @Override
    public void doStop() {
    }
}

