/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;

public abstract class AbstractActivitiSmartLifeCycle
implements SmartLifecycle,
DisposableBean {
    private static Logger logger = LoggerFactory.getLogger(AbstractActivitiSmartLifeCycle.class);
    private Object lifeCycleMonitor = new Object();
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private volatile boolean running = false;

    public abstract void doStart();

    public abstract void doStop();

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            if (!this.running) {
                logger.info("Starting...");
                this.doStart();
                this.running = true;
                logger.info("Started.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            if (this.running) {
                logger.info("Stopping...");
                this.doStop();
                this.running = false;
                logger.info("Stopped.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void destroy() {
        this.stop();
    }
}

