/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.api.model.shared.event.RuntimeEvent;
import org.activiti.api.process.model.ProcessDefinition;
import org.activiti.api.process.model.events.ProcessDeployedEvent;
import org.activiti.api.process.runtime.events.listener.ProcessRuntimeEventListener;
import org.activiti.api.runtime.event.impl.ProcessDeployedEventImpl;
import org.activiti.api.runtime.event.impl.ProcessDeployedEvents;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.runtime.api.model.impl.APIProcessDefinitionConverter;
import org.activiti.spring.AbstractActivitiSmartLifeCycle;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.StreamUtils;

public class ProcessDeployedEventProducer
extends AbstractActivitiSmartLifeCycle {
    private RepositoryService repositoryService;
    private APIProcessDefinitionConverter converter;
    private List<ProcessRuntimeEventListener<ProcessDeployedEvent>> listeners;
    private ApplicationEventPublisher eventPublisher;

    public ProcessDeployedEventProducer(RepositoryService repositoryService, APIProcessDefinitionConverter converter, List<ProcessRuntimeEventListener<ProcessDeployedEvent>> listeners, ApplicationEventPublisher eventPublisher) {
        this.repositoryService = repositoryService;
        this.converter = converter;
        this.listeners = listeners;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void doStart() {
        List processDefinitions = this.converter.from((Collection)this.repositoryService.createProcessDefinitionQuery().latestVersion().list());
        ArrayList<ProcessDeployedEventImpl> processDeployedEvents = new ArrayList<ProcessDeployedEventImpl>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            try {
                InputStream inputStream = this.repositoryService.getProcessModel(processDefinition.getId());
                try {
                    String xmlModel = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    ProcessDeployedEventImpl processDeployedEvent = new ProcessDeployedEventImpl(processDefinition, xmlModel);
                    processDeployedEvents.add(processDeployedEvent);
                    for (ProcessRuntimeEventListener<ProcessDeployedEvent> listener : this.listeners) {
                        listener.onEvent((RuntimeEvent)processDeployedEvent);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new ActivitiException("Error occurred while getting process model '" + processDefinition.getId() + "' : ", (Throwable)e);
            }
        }
        if (!processDeployedEvents.isEmpty()) {
            this.eventPublisher.publishEvent((Object)new ProcessDeployedEvents(processDeployedEvents));
        }
    }

    @Override
    public void doStop() {
    }
}

