/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.application;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.activiti.application.ApplicationLoadException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ApplicationDiscovery {
    private ResourcePatternResolver resourceLoader;
    private String applicationsLocation;

    public ApplicationDiscovery(ResourcePatternResolver resourceLoader, String applicationsLocation) {
        this.resourceLoader = resourceLoader;
        this.applicationsLocation = applicationsLocation;
    }

    public List<Resource> discoverApplications() {
        List<Resource> resources = new ArrayList<Resource>();
        Resource resource = this.resourceLoader.getResource(this.applicationsLocation);
        if (resource.exists()) {
            try {
                resources = Arrays.asList(this.resourceLoader.getResources(this.applicationsLocation + "**.zip"));
            }
            catch (IOException e) {
                throw new ApplicationLoadException("Unable to load application resources", e);
            }
        }
        return resources;
    }
}

