/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;
import org.apache.commons.lang3.StringUtils;

public class ExclusiveGatewayValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List gateways = process.findFlowElementsOfType(ExclusiveGateway.class);
        for (ExclusiveGateway gateway : gateways) {
            this.validateExclusiveGateway(process, gateway, errors);
        }
    }

    public void validateExclusiveGateway(Process process, ExclusiveGateway exclusiveGateway, List<ValidationError> errors) {
        if (exclusiveGateway.getOutgoingFlows().isEmpty()) {
            this.addError(errors, "EXCLUSIVE_GATEWAY_NO_OUTGOING_SEQ_FLOW", process, (BaseElement)exclusiveGateway);
        } else if (exclusiveGateway.getOutgoingFlows().size() == 1) {
            SequenceFlow sequenceFlow = (SequenceFlow)exclusiveGateway.getOutgoingFlows().get(0);
            if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getConditionExpression())) {
                this.addError(errors, "EXCLUSIVE_GATEWAY_CONDITION_NOT_ALLOWED_ON_SINGLE_SEQ_FLOW", process, (BaseElement)exclusiveGateway);
            }
        } else {
            String defaultSequenceFlow = exclusiveGateway.getDefaultFlow();
            ArrayList<SequenceFlow> flowsWithoutCondition = new ArrayList<SequenceFlow>();
            for (SequenceFlow flow : exclusiveGateway.getOutgoingFlows()) {
                String condition = flow.getConditionExpression();
                boolean isDefaultFlow = flow.getId() != null && flow.getId().equals(defaultSequenceFlow);
                boolean hasConditon = StringUtils.isNotEmpty((CharSequence)condition);
                if (!hasConditon && !isDefaultFlow) {
                    flowsWithoutCondition.add(flow);
                }
                if (!hasConditon || !isDefaultFlow) continue;
                this.addError(errors, "EXCLUSIVE_GATEWAY_CONDITION_ON_DEFAULT_SEQ_FLOW", process, (BaseElement)exclusiveGateway);
            }
            if (!flowsWithoutCondition.isEmpty()) {
                this.addWarning(errors, "EXCLUSIVE_GATEWAY_SEQ_FLOW_WITHOUT_CONDITIONS", process, (BaseElement)exclusiveGateway);
            }
        }
    }
}

