/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.TaskWithFieldExtensions;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public abstract class ExternalInvocationTaskValidator
extends ProcessLevelValidator {
    protected void validateFieldDeclarationsForEmail(Process process, TaskWithFieldExtensions task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean toDefined = false;
        boolean textOrHtmlDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            if (fieldExtension.getFieldName().equals("to")) {
                toDefined = true;
            }
            if (fieldExtension.getFieldName().equals("html")) {
                textOrHtmlDefined = true;
            }
            if (fieldExtension.getFieldName().equals("htmlVar")) {
                textOrHtmlDefined = true;
            }
            if (fieldExtension.getFieldName().equals("text")) {
                textOrHtmlDefined = true;
            }
            if (!fieldExtension.getFieldName().equals("textVar")) continue;
            textOrHtmlDefined = true;
        }
        if (!toDefined) {
            this.addError(errors, "MAIL_TASK_NO_RECIPIENT", process, (BaseElement)task);
        }
        if (!textOrHtmlDefined) {
            this.addError(errors, "MAIL_TASK_NO_CONTENT", process, (BaseElement)task);
        }
    }

    protected void validateFieldDeclarationsForShell(Process process, TaskWithFieldExtensions task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean shellCommandDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            String fieldName = fieldExtension.getFieldName();
            String fieldValue = fieldExtension.getStringValue();
            if (fieldName.equals("command")) {
                shellCommandDefined = true;
            }
            if (!fieldName.equals("wait") && !fieldName.equals("redirectError") && !fieldName.equals("cleanEnv") || fieldValue.toLowerCase().equals("true") || fieldValue.toLowerCase().equals("false")) continue;
            this.addError(errors, "SHELL_TASK_INVALID_PARAM", process, (BaseElement)task);
        }
        if (!shellCommandDefined) {
            this.addError(errors, "SHELL_TASK_NO_COMMAND", process, (BaseElement)task);
        }
    }

    protected void validateFieldDeclarationsForDmn(Process process, TaskWithFieldExtensions task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean keyDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            String fieldName = fieldExtension.getFieldName();
            String fieldValue = fieldExtension.getStringValue();
            if (!fieldName.equals("decisionTableReferenceKey") || fieldValue == null || fieldValue.length() <= 0) continue;
            keyDefined = true;
        }
        if (!keyDefined) {
            this.addError(errors, "DMN_TASK_NO_KEY", process, (BaseElement)task);
        }
    }
}

