/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DataAssociation;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;
import org.apache.commons.lang3.StringUtils;

public class FlowElementValidator
extends ProcessLevelValidator {
    protected static final int ID_MAX_LENGTH = 255;

    private void handleValidations(Process process, Activity activity, List<ValidationError> errors) {
        this.handleConstraints(process, activity, errors);
        this.handleMultiInstanceLoopCharacteristics(process, activity, errors);
        this.handleDataAssociations(process, activity, errors);
    }

    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        for (FlowElement flowElement : process.getFlowElements()) {
            this.handleFlowElement(process, flowElement, errors);
        }
    }

    private void handleFlowElement(Process process, FlowElement flowElement, List<ValidationError> errors) {
        if (flowElement instanceof Activity) {
            Activity activity = (Activity)flowElement;
            if (activity instanceof SubProcess) {
                SubProcess subProcess = (SubProcess)activity;
                for (FlowElement subElement : subProcess.getFlowElements()) {
                    this.handleFlowElement(process, subElement, errors);
                }
            } else {
                this.handleValidations(process, activity, errors);
            }
        }
    }

    protected void handleConstraints(Process process, Activity activity, List<ValidationError> errors) {
        if (activity.getId() != null && activity.getId().length() > 255) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("maxLength", String.valueOf(255));
            this.addError(errors, "FLOW_ELEMENT_ID_TOO_LONG", process, (BaseElement)activity, params);
        }
    }

    protected void handleMultiInstanceLoopCharacteristics(Process process, Activity activity, List<ValidationError> errors) {
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = activity.getLoopCharacteristics();
        if (multiInstanceLoopCharacteristics != null && StringUtils.isEmpty((CharSequence)multiInstanceLoopCharacteristics.getLoopCardinality()) && StringUtils.isEmpty((CharSequence)multiInstanceLoopCharacteristics.getInputDataItem())) {
            this.addError(errors, "MULTI_INSTANCE_MISSING_COLLECTION", process, (BaseElement)activity);
        }
    }

    protected void handleDataAssociations(Process process, Activity activity, List<ValidationError> errors) {
        if (activity.getDataInputAssociations() != null) {
            for (DataAssociation dataAssociation : activity.getDataInputAssociations()) {
                if (!StringUtils.isEmpty((CharSequence)dataAssociation.getTargetRef())) continue;
                this.addError(errors, "DATA_ASSOCIATION_MISSING_TARGETREF", process, (BaseElement)activity);
            }
        }
        if (activity.getDataOutputAssociations() != null) {
            for (DataAssociation dataAssociation : activity.getDataOutputAssociations()) {
                if (!StringUtils.isEmpty((CharSequence)dataAssociation.getTargetRef())) continue;
                this.addError(errors, "DATA_ASSOCIATION_MISSING_TARGETREF", process, (BaseElement)activity);
            }
        }
    }
}

