/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.Collection;
import java.util.List;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.Association;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ValidatorImpl;
import org.apache.commons.lang3.StringUtils;

public class AssociationValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        Collection artifacts = bpmnModel.getGlobalArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!(artifact instanceof Association)) continue;
                this.validate(null, (Association)artifact, errors);
            }
        }
        for (Process process : bpmnModel.getProcesses()) {
            artifacts = process.getArtifacts();
            for (Artifact artifact : artifacts) {
                if (!(artifact instanceof Association)) continue;
                this.validate(process, (Association)artifact, errors);
            }
        }
    }

    protected void validate(Process process, Association association, List<ValidationError> errors) {
        if (StringUtils.isEmpty((CharSequence)association.getSourceRef())) {
            this.addError(errors, "ASSOCIATION_INVALID_SOURCE_REFERENCE", process, (BaseElement)association);
        }
        if (StringUtils.isEmpty((CharSequence)association.getTargetRef())) {
            this.addError(errors, "ASSOCIATION_INVALID_TARGET_REFERENCE", process, (BaseElement)association);
        }
    }
}

