/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.core.el.juel.util.SimpleContext;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;
import org.apache.commons.lang3.StringUtils;

public class SequenceflowValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List sequenceFlows = process.findFlowElementsOfType(SequenceFlow.class);
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            String conditionExpression;
            String sourceRef = sequenceFlow.getSourceRef();
            String targetRef = sequenceFlow.getTargetRef();
            if (StringUtils.isEmpty((CharSequence)sourceRef)) {
                this.addError(errors, "activiti-seq-flow-invalid-src", process, (BaseElement)sequenceFlow, "Invalid source for sequenceflow");
            }
            if (StringUtils.isEmpty((CharSequence)targetRef)) {
                this.addError(errors, "activiti-seq-flow-invalid-target", process, (BaseElement)sequenceFlow, "Invalid target for sequenceflow");
            }
            FlowElement source = process.getFlowElement(sourceRef, true);
            FlowElement target = process.getFlowElement(targetRef, true);
            if (source == null) {
                this.addError(errors, "activiti-seq-flow-invalid-src", process, (BaseElement)sequenceFlow, "Invalid source for sequenceflow");
            }
            if (target == null) {
                this.addError(errors, "activiti-seq-flow-invalid-target", process, (BaseElement)sequenceFlow, "Invalid target for sequenceflow");
            }
            if (source != null && target != null) {
                FlowElementsContainer sourceContainer = process.getFlowElementsContainer(source.getId());
                FlowElementsContainer targetContainer = process.getFlowElementsContainer(target.getId());
                if (sourceContainer == null) {
                    this.addError(errors, "activiti-seq-flow-invalid-src", process, (BaseElement)sequenceFlow, "Invalid source for sequenceflow");
                }
                if (targetContainer == null) {
                    this.addError(errors, "activiti-seq-flow-invalid-target", process, (BaseElement)sequenceFlow, "Invalid target for sequenceflow");
                }
                if (sourceContainer != null && targetContainer != null && !sourceContainer.equals(targetContainer)) {
                    this.addError(errors, "activiti-seq-flow-invalid-target", process, (BaseElement)sequenceFlow, "Invalid target for sequenceflow, the target isn't defined in the same scope as the source");
                }
            }
            if ((conditionExpression = sequenceFlow.getConditionExpression()) == null) continue;
            try {
                ExpressionFactory.newInstance().createValueExpression((ELContext)new SimpleContext(), conditionExpression.trim(), Object.class);
            }
            catch (Exception e) {
                this.addError(errors, "activiti-seq-flow-invalid-conditional-expression", process, (BaseElement)sequenceFlow, "Conditional expression is not valid");
            }
        }
    }
}

