/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BusinessRuleTask;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;

public class BusinessRuleTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        BusinessRuleTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        BusinessRuleTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("BusinessRule", BusinessRuleTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(BusinessRuleTask.class, BusinessRuleTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "BusinessRule";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        BusinessRuleTask ruleTask = (BusinessRuleTask)baseElement;
        propertiesNode.put("ruletask_class", ruleTask.getClassName());
        propertiesNode.put("ruletask_variables_input", this.convertListToCommaSeparatedString(ruleTask.getInputVariables()));
        propertiesNode.put("ruletask_result", ruleTask.getResultVariableName());
        propertiesNode.put("ruletask_rules", this.convertListToCommaSeparatedString(ruleTask.getRuleNames()));
        if (ruleTask.isExclude()) {
            propertiesNode.put("ruletask_exclude", "Yes");
        }
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        BusinessRuleTask task = new BusinessRuleTask();
        task.setClassName(this.getPropertyValueAsString("ruletask_class", elementNode));
        task.setInputVariables(this.getPropertyValueAsList("ruletask_variables_input", elementNode));
        task.setResultVariableName(this.getPropertyValueAsString("ruletask_result", elementNode));
        task.setRuleNames(this.getPropertyValueAsList("ruletask_rules", elementNode));
        task.setExclude(this.getPropertyValueAsBoolean("ruletask_exclude", elementNode));
        return task;
    }
}

