/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.agenda;

import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.agenda.AbstractOperation;
import org.activiti.engine.impl.delegate.ActivityBehavior;
import org.activiti.engine.impl.delegate.TriggerableActivityBehavior;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class TriggerExecutionOperation
extends AbstractOperation {
    public TriggerExecutionOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (!(currentFlowElement instanceof FlowNode)) throw new ActivitiException("Programmatic error: no current flow element found or invalid type: " + String.valueOf(currentFlowElement) + ". Halting.");
        ActivityBehavior activityBehavior = (ActivityBehavior)((FlowNode)currentFlowElement).getBehavior();
        if (!(activityBehavior instanceof TriggerableActivityBehavior)) throw new ActivitiException("Invalid behavior: " + String.valueOf(activityBehavior) + " should implement " + TriggerableActivityBehavior.class.getName());
        if (currentFlowElement instanceof BoundaryEvent) {
            this.commandContext.getHistoryManager().recordActivityStart(this.execution);
        }
        ((TriggerableActivityBehavior)activityBehavior).trigger(this.execution, null, null);
        if (!(currentFlowElement instanceof BoundaryEvent)) return;
        this.commandContext.getHistoryManager().recordActivityEnd(this.execution, null);
    }
}

