/*
 * Copyright 2010-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.engine.impl.persistence.entity.data;

import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.HistoricProcessInstanceQueryImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;

/**

 */
public interface HistoricProcessInstanceDataManager extends DataManager<HistoricProcessInstanceEntity> {
    HistoricProcessInstanceEntity create(ExecutionEntity processInstanceExecutionEntity);

    List<String> findHistoricProcessInstanceIdsByProcessDefinitionId(String processDefinitionId);

    List<HistoricProcessInstanceEntity> findHistoricProcessInstancesBySuperProcessInstanceId(
        String superProcessInstanceId
    );

    long findHistoricProcessInstanceCountByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery);

    List<HistoricProcessInstance> findHistoricProcessInstancesByQueryCriteria(
        HistoricProcessInstanceQueryImpl historicProcessInstanceQuery
    );

    List<HistoricProcessInstance> findHistoricProcessInstancesAndVariablesByQueryCriteria(
        HistoricProcessInstanceQueryImpl historicProcessInstanceQuery
    );

    List<HistoricProcessInstance> findHistoricProcessInstancesByNativeQuery(
        Map<String, Object> parameterMap,
        int firstResult,
        int maxResults
    );

    long findHistoricProcessInstanceCountByNativeQuery(Map<String, Object> parameterMap);
}
