/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.db;

import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cmd.GetNextIdBlockCmd;
import org.activiti.engine.impl.db.IdBlock;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandExecutor;

public class DbIdGenerator
implements IdGenerator {
    protected int idBlockSize;
    protected long nextId;
    protected long lastId = -1L;
    protected CommandExecutor commandExecutor;
    protected CommandConfig commandConfig;

    @Override
    public synchronized String getNextId() {
        if (this.lastId < this.nextId) {
            this.getNewBlock();
        }
        long _nextId = this.nextId++;
        return Long.toString(_nextId);
    }

    protected synchronized void getNewBlock() {
        IdBlock idBlock = this.commandExecutor.execute(this.commandConfig, new GetNextIdBlockCmd(this.idBlockSize));
        this.nextId = idBlock.getNextId();
        this.lastId = idBlock.getLastId();
    }

    public int getIdBlockSize() {
        return this.idBlockSize;
    }

    public void setIdBlockSize(int idBlockSize) {
        this.idBlockSize = idBlockSize;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public CommandConfig getCommandConfig() {
        return this.commandConfig;
    }

    public void setCommandConfig(CommandConfig commandConfig) {
        this.commandConfig = commandConfig;
    }
}

