/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.Execution;

public abstract class NeedsActiveExecutionCmd<T>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;

    public NeedsActiveExecutionCmd(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public T execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiIllegalArgumentException("executionId is null");
        }
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        if (execution.isSuspended()) {
            throw new ActivitiException(this.getSuspendedExceptionMessage());
        }
        return this.execute(commandContext, execution);
    }

    protected abstract T execute(CommandContext var1, ExecutionEntity var2);

    protected String getSuspendedExceptionMessage() {
        return "Cannot execution operation because execution '" + this.executionId + "' is suspended";
    }
}

