/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.bpmn.model.AdhocSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.Execution;

public class ExecuteActivityForAdhocSubProcessCmd
implements Command<Execution>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String activityId;

    public ExecuteActivityForAdhocSubProcessCmd(String executionId, String activityId) {
        this.executionId = executionId;
        this.activityId = activityId;
    }

    @Override
    public Execution execute(CommandContext commandContext) {
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("No execution found for id '" + this.executionId + "'", ExecutionEntity.class);
        }
        if (!(execution.getCurrentFlowElement() instanceof AdhocSubProcess)) {
            throw new ActivitiException("The current flow element of the requested execution is not an ad-hoc sub process");
        }
        FlowNode foundNode = null;
        AdhocSubProcess adhocSubProcess = (AdhocSubProcess)execution.getCurrentFlowElement();
        if (adhocSubProcess.hasSequentialOrdering() && execution.getExecutions().size() > 0) {
            throw new ActivitiException("Sequential ad-hoc sub process already has an active execution");
        }
        for (FlowElement flowElement : adhocSubProcess.getFlowElements()) {
            FlowNode flowNode;
            if (!this.activityId.equals(flowElement.getId()) || !(flowElement instanceof FlowNode) || (flowNode = (FlowNode)flowElement).getIncomingFlows().size() != 0) continue;
            foundNode = flowNode;
        }
        if (foundNode == null) {
            throw new ActivitiException("The requested activity with id " + this.activityId + " can not be enabled");
        }
        ExecutionEntity activityExecution = Context.getCommandContext().getExecutionEntityManager().createChildExecution(execution);
        activityExecution.setCurrentFlowElement((FlowElement)foundNode);
        Context.getAgenda().planContinueProcessOperation(activityExecution);
        return activityExecution;
    }
}

