/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.repository.ProcessDefinition;

public class ProcessDefinitionRetriever {
    private String tenantId;
    private DeploymentManager deploymentCache;

    public ProcessDefinitionRetriever(String tenantId, DeploymentManager deploymentCache) {
        this.tenantId = tenantId;
        this.deploymentCache = deploymentCache;
    }

    public ProcessDefinition getProcessDefinition(String processDefinitionId, String processDefinitionKey) {
        if (processDefinitionId == null && processDefinitionKey == null) {
            throw new ActivitiIllegalArgumentException("processDefinitionKey and processDefinitionId are null");
        }
        ProcessDefinition processDefinition = this.getProcessDefinitionByProcessDefinitionId(processDefinitionId, this.deploymentCache);
        if (processDefinition == null) {
            ProcessDefinition processDefinition2 = processDefinition = processDefinitionKey != null && this.hasNoTenant(this.tenantId) ? this.getProcessDefinitionByProcessDefinitionKey(processDefinitionKey, this.deploymentCache) : this.getProcessDefinitionByProcessDefinitionKeyAndTenantId(processDefinitionKey, this.tenantId, this.deploymentCache);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for key '" + processDefinitionKey + "' for tenant identifier " + this.tenantId, ProcessDefinition.class);
            }
        }
        return processDefinition;
    }

    private ProcessDefinition getProcessDefinitionByProcessDefinitionId(String processDefinitionId, DeploymentManager deploymentCache) {
        ProcessDefinition processDefinition = null;
        if (processDefinitionId != null) {
            processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
        }
        return processDefinition;
    }

    private ProcessDefinition getProcessDefinitionByProcessDefinitionKey(String processDefinitionKey, DeploymentManager deploymentCache) {
        ProcessDefinition processDefinition = null;
        processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(processDefinitionKey);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("No process definition found for key '" + processDefinitionKey + "'", ProcessDefinition.class);
        }
        return processDefinition;
    }

    private ProcessDefinition getProcessDefinitionByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String tenantId, DeploymentManager deploymentCache) {
        ProcessDefinition processDefinition = null;
        if (processDefinitionKey != null && tenantId != null && !"".equals(tenantId)) {
            processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
        }
        return processDefinition;
    }

    private boolean hasNoTenant(String tenantId) {
        return tenantId == null || "".equals(tenantId);
    }
}

