/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.List;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.factory.MessageExecutionContext;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;

public class IntermediateCatchMessageEventActivityBehavior
extends IntermediateCatchEventActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected final MessageEventDefinition messageEventDefinition;
    protected final MessageExecutionContext messageExecutionContext;

    public IntermediateCatchMessageEventActivityBehavior(MessageEventDefinition messageEventDefinition, MessageExecutionContext messageExecutionContext) {
        this.messageEventDefinition = messageEventDefinition;
        this.messageExecutionContext = messageExecutionContext;
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        MessageEventSubscriptionEntity subscription = this.messageExecutionContext.createMessageEventSubscription(commandContext, execution);
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createMessageWaitingEvent(execution, subscription.getEventName(), subscription.getConfiguration()));
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        ExecutionEntity executionEntity = this.deleteMessageEventSubScription(execution);
        this.leaveIntermediateCatchEvent(executionEntity);
    }

    @Override
    public void eventCancelledByEventGateway(DelegateExecution execution) {
        this.deleteMessageEventSubScription(execution);
        Context.getCommandContext().getExecutionEntityManager().deleteExecutionAndRelatedData((ExecutionEntity)execution, "event based gateway cancel");
    }

    protected ExecutionEntity deleteMessageEventSubScription(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        String messageName = this.messageExecutionContext.getMessageName(execution);
        EventSubscriptionEntityManager eventSubscriptionEntityManager = Context.getCommandContext().getEventSubscriptionEntityManager();
        List<EventSubscriptionEntity> eventSubscriptions = executionEntity.getEventSubscriptions();
        for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
            if (!(eventSubscription instanceof MessageEventSubscriptionEntity) || !eventSubscription.getEventName().equals(messageName)) continue;
            eventSubscriptionEntityManager.delete(eventSubscription);
        }
        return executionEntity;
    }

    public MessageEventDefinition getMessageEventDefinition() {
        return this.messageEventDefinition;
    }

    public MessageExecutionContext getMessageExecutionContext() {
        return this.messageExecutionContext;
    }
}

