/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.deployer;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.impl.asyncexecutor.JobManager;
import org.activiti.engine.impl.cmd.CancelJobsCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti.engine.impl.util.CollectionUtil;

public class TimerManager {
    protected void removeObsoleteTimers(ProcessDefinitionEntity processDefinition) {
        List<TimerJobEntity> jobsToDelete = null;
        jobsToDelete = processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId()) ? Context.getCommandContext().getTimerJobEntityManager().findJobsByTypeAndProcessDefinitionKeyAndTenantId("timer-start-event", processDefinition.getKey(), processDefinition.getTenantId()) : Context.getCommandContext().getTimerJobEntityManager().findJobsByTypeAndProcessDefinitionKeyNoTenantId("timer-start-event", processDefinition.getKey());
        if (jobsToDelete != null) {
            for (TimerJobEntity job : jobsToDelete) {
                new CancelJobsCmd(job.getId()).execute(Context.getCommandContext());
            }
        }
    }

    protected void removeExistingTimerStartEventJobs() {
        List<TimerJobEntity> timerStartJobs = Context.getCommandContext().getTimerJobEntityManager().findTimerStartEvents();
        if (timerStartJobs != null) {
            for (TimerJobEntity timerStartJob : timerStartJobs) {
                new CancelJobsCmd(timerStartJob.getId()).execute(Context.getCommandContext());
            }
        }
    }

    protected void scheduleTimers(ProcessDefinitionEntity processDefinition, Process process) {
        JobManager jobManager = Context.getCommandContext().getJobManager();
        List<TimerJobEntity> timers = this.getTimerDeclarations(processDefinition, process);
        for (TimerJobEntity timer : timers) {
            jobManager.scheduleTimerJob(timer);
        }
    }

    protected List<TimerJobEntity> getTimerDeclarations(ProcessDefinitionEntity processDefinition, Process process) {
        JobManager jobManager = Context.getCommandContext().getJobManager();
        ArrayList<TimerJobEntity> timers = new ArrayList<TimerJobEntity>();
        if (process != null && CollectionUtil.isNotEmpty(process.getFlowElements())) {
            for (FlowElement element : process.getFlowElements()) {
                TimerEventDefinition timerEventDefinition;
                TimerJobEntity timerJob;
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(element instanceof StartEvent) || !CollectionUtil.isNotEmpty((startEvent = (StartEvent)element).getEventDefinitions()) || !((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof TimerEventDefinition) || (timerJob = jobManager.createTimerJob(timerEventDefinition = (TimerEventDefinition)eventDefinition, false, null, "timer-start-event", TimerEventHandler.createConfiguration(startEvent.getId(), timerEventDefinition.getEndDate(), timerEventDefinition.getCalendarName()))) == null) continue;
                timerJob.setProcessDefinitionId(processDefinition.getId());
                if (processDefinition.getTenantId() != null) {
                    timerJob.setTenantId(processDefinition.getTenantId());
                }
                timers.add(timerJob);
            }
        }
        return timers;
    }
}

