/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.data;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.impl.bpmn.data.FieldBaseStructureDefinition;
import org.activiti.engine.impl.bpmn.data.StructureInstance;

public class FieldBaseStructureInstance
implements StructureInstance {
    protected FieldBaseStructureDefinition structureDefinition;
    protected Map<String, Object> fieldValues;

    public FieldBaseStructureInstance(FieldBaseStructureDefinition structureDefinition) {
        this.structureDefinition = structureDefinition;
        this.fieldValues = new HashMap<String, Object>();
    }

    public Object getFieldValue(String fieldName) {
        return this.fieldValues.get(fieldName);
    }

    public void setFieldValue(String fieldName, Object value) {
        this.fieldValues.put(fieldName, value);
    }

    public int getFieldSize() {
        return this.structureDefinition.getFieldSize();
    }

    public String getFieldNameAt(int index) {
        return this.structureDefinition.getFieldNameAt(index);
    }

    @Override
    public Object[] toArray() {
        int fieldSize = this.getFieldSize();
        Object[] arguments = new Object[fieldSize];
        for (int i = 0; i < fieldSize; ++i) {
            Object argument;
            String fieldName = this.getFieldNameAt(i);
            arguments[i] = argument = this.getFieldValue(fieldName);
        }
        return arguments;
    }

    @Override
    public void loadFrom(Object[] array) {
        int fieldSize = this.getFieldSize();
        for (int i = 0; i < fieldSize; ++i) {
            String fieldName = this.getFieldNameAt(i);
            Object fieldValue = array[i];
            this.setFieldValue(fieldName, fieldValue);
        }
    }
}

