/*
 * Copyright 2010-2025 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.engine.impl.bpmn.parser.factory;

import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.engine.impl.delegate.MessagePayloadMappingProvider;
import org.activiti.engine.impl.el.ExpressionManager;

public class DefaultMessageExecutionContextFactory implements MessageExecutionContextFactory {

    public DefaultMessageExecutionContextFactory() {
        super();
    }

    @Override
    public MessageExecutionContext create(
        MessageEventDefinition messageEventDefinition,
        MessagePayloadMappingProvider messagePayloadMappingProvider,
        ExpressionManager expressionManager
    ) {
        return new DefaultMessageExecutionContext(
            messageEventDefinition,
            expressionManager,
            messagePayloadMappingProvider
        );
    }
}
