/*
 * Copyright 2010-2025 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.engine.impl.persistence.entity.data;

import java.util.List;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;

/**

 */
public interface IdentityLinkDataManager extends DataManager<IdentityLinkEntity> {
    List<IdentityLinkEntity> findIdentityLinksByTaskId(String taskId);

    List<IdentityLinkEntity> findIdentityLinksByProcessInstanceId(String processInstanceId);

    List<IdentityLinkEntity> findIdentityLinksByProcessDefinitionId(String processDefinitionId);

    List<IdentityLinkEntity> findIdentityLinkByTaskUserGroupAndType(
        String taskId,
        String userId,
        String groupId,
        String type
    );

    List<IdentityLinkEntity> findIdentityLinkByProcessInstanceUserGroupAndType(
        String processInstanceId,
        String userId,
        String groupId,
        String type
    );

    List<IdentityLinkEntity> findIdentityLinkByProcessDefinitionUserAndGroup(
        String processDefinitionId,
        String userId,
        String groupId
    );

    void deleteIdentityLinksByProcDef(String processDefId);
}
