/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.agenda;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.AdhocSubProcess;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.CancelEventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.bpmn.model.helper.LinkThrowEventFlowNodeHelper;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.agenda.AbstractOperation;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.UelExpressionCondition;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.CollectionUtil;
import org.activiti.engine.impl.util.condition.ConditionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeOutgoingSequenceFlowsOperation
extends AbstractOperation {
    private static final Logger logger = LoggerFactory.getLogger(TakeOutgoingSequenceFlowsOperation.class);
    protected boolean evaluateConditions;

    public TakeOutgoingSequenceFlowsOperation(CommandContext commandContext, ExecutionEntity executionEntity, boolean evaluateConditions) {
        super(commandContext, executionEntity);
        this.evaluateConditions = evaluateConditions;
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (currentFlowElement instanceof Activity && ((Activity)currentFlowElement).isForCompensation()) {
            this.cleanupCompensation();
            return;
        }
        this.cleanupExecutions(currentFlowElement);
        if (currentFlowElement instanceof FlowNode) {
            this.handleFlowNode((FlowNode)currentFlowElement);
        } else if (currentFlowElement instanceof SequenceFlow) {
            this.handleSequenceFlow();
        }
    }

    protected void handleFlowNode(FlowNode flowNode) {
        this.handleActivityEnd(flowNode);
        if (flowNode.getParentContainer() != null && flowNode.getParentContainer() instanceof AdhocSubProcess) {
            this.handleAdhocSubProcess(flowNode);
        } else {
            this.leaveFlowNode(flowNode);
        }
    }

    protected void handleActivityEnd(FlowNode flowNode) {
        if (!this.execution.isProcessInstanceType()) {
            this.handleBoundaryEvent(flowNode);
            if (CollectionUtil.isNotEmpty(flowNode.getExecutionListeners())) {
                this.executeExecutionListeners((HasExecutionListeners)flowNode, "end");
            }
            this.commandContext.getHistoryManager().recordActivityEnd(this.execution, null);
            if (!(this.execution.getCurrentFlowElement() instanceof SubProcess) && !(flowNode.getBehavior() instanceof MultiInstanceActivityBehavior)) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_COMPLETED, this.execution, (FlowElement)flowNode));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void leaveFlowNode(FlowNode flowNode) {
        logger.debug("Leaving flow node {} with id '{}' by following it's {} outgoing sequenceflow", new Object[]{flowNode.getClass(), flowNode.getId(), flowNode.getOutgoingFlows().size()});
        String defaultSequenceFlowId = null;
        if (flowNode instanceof Activity) {
            defaultSequenceFlowId = ((Activity)flowNode).getDefaultFlow();
        } else if (flowNode instanceof Gateway) {
            defaultSequenceFlowId = ((Gateway)flowNode).getDefaultFlow();
        }
        ArrayList<SequenceFlow> outgoingSequenceFlows = new ArrayList<SequenceFlow>();
        for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
            String skipExpressionString = sequenceFlow.getSkipExpression();
            if (!SkipExpressionUtil.isSkipExpressionEnabled((DelegateExecution)this.execution, skipExpressionString)) {
                if (this.evaluateConditions && (!this.evaluateConditions || !ConditionUtil.hasTrueCondition(sequenceFlow, this.execution) || defaultSequenceFlowId != null && defaultSequenceFlowId.equals(sequenceFlow.getId()))) continue;
                outgoingSequenceFlows.add(sequenceFlow);
                continue;
            }
            if (flowNode.getOutgoingFlows().size() != 1 && !SkipExpressionUtil.shouldSkipFlowElement(this.commandContext, this.execution, skipExpressionString)) continue;
            outgoingSequenceFlows.add(sequenceFlow);
        }
        if (outgoingSequenceFlows.size() == 0 && this.evaluateConditions && defaultSequenceFlowId != null) {
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                if (!defaultSequenceFlowId.equals(sequenceFlow.getId())) continue;
                outgoingSequenceFlows.add(sequenceFlow);
                break;
            }
        }
        if (outgoingSequenceFlows.size() == 0 && !flowNode.isLinkThrowEvent()) {
            if (flowNode.getOutgoingFlows() != null && flowNode.getOutgoingFlows().size() != 0) throw new ActivitiException("No outgoing sequence flow of element '" + flowNode.getId() + "' could be selected for continuing the process");
            logger.debug("No outgoing sequence flow found for flow node '{}'.", (Object)flowNode.getId());
            Context.getAgenda().planEndExecutionOperation(this.execution);
            return;
        } else {
            ExecutionEntityManager executionEntityManager = this.commandContext.getExecutionEntityManager();
            ArrayList<ExecutionEntity> outgoingExecutions = new ArrayList<ExecutionEntity>(flowNode.getOutgoingFlows().size());
            if (flowNode.isLinkThrowEvent()) {
                FlowNode node = LinkThrowEventFlowNodeHelper.findRelatedIntermediateCatchEventForLinkEvent((ThrowEvent)((ThrowEvent)flowNode));
                this.execution.setCurrentFlowElement((FlowElement)node);
            } else {
                SequenceFlow sequenceFlow = (SequenceFlow)outgoingSequenceFlows.get(0);
                this.execution.setCurrentFlowElement((FlowElement)sequenceFlow);
            }
            this.execution.setActive(true);
            outgoingExecutions.add(this.execution);
            if (outgoingSequenceFlows.size() > 1) {
                for (int i = 1; i < outgoingSequenceFlows.size(); ++i) {
                    ExecutionEntity parent = this.execution.getParentId() != null ? this.execution.getParent() : this.execution;
                    ExecutionEntity outgoingExecutionEntity = this.commandContext.getExecutionEntityManager().createChildExecution(parent);
                    SequenceFlow outgoingSequenceFlow = (SequenceFlow)outgoingSequenceFlows.get(i);
                    outgoingExecutionEntity.setCurrentFlowElement((FlowElement)outgoingSequenceFlow);
                    executionEntityManager.insert(outgoingExecutionEntity);
                    outgoingExecutions.add(outgoingExecutionEntity);
                }
            }
            for (ExecutionEntity outgoingExecution : outgoingExecutions) {
                Context.getAgenda().planContinueProcessOperation(outgoingExecution);
            }
        }
    }

    protected void handleAdhocSubProcess(FlowNode flowNode) {
        Expression expression;
        UelExpressionCondition condition;
        boolean completeAdhocSubProcess = false;
        AdhocSubProcess adhocSubProcess = (AdhocSubProcess)flowNode.getParentContainer();
        if (adhocSubProcess.getCompletionCondition() != null && (condition = new UelExpressionCondition(expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(adhocSubProcess.getCompletionCondition()))).evaluate(adhocSubProcess.getId(), this.execution)) {
            completeAdhocSubProcess = true;
        }
        if (flowNode.getOutgoingFlows().size() > 0) {
            this.leaveFlowNode(flowNode);
        } else {
            this.commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(this.execution, null);
        }
        if (completeAdhocSubProcess) {
            boolean endAdhocSubProcess = true;
            if (!adhocSubProcess.isCancelRemainingInstances()) {
                List<ExecutionEntity> childExecutions = this.commandContext.getExecutionEntityManager().findChildExecutionsByParentExecutionId(this.execution.getParentId());
                for (ExecutionEntity executionEntity : childExecutions) {
                    if (executionEntity.getId().equals(this.execution.getId())) continue;
                    endAdhocSubProcess = false;
                    break;
                }
            }
            if (endAdhocSubProcess) {
                Context.getAgenda().planEndExecutionOperation(this.execution.getParent());
            }
        }
    }

    protected void handleSequenceFlow() {
        this.commandContext.getHistoryManager().recordActivityEnd(this.execution, null);
        Context.getAgenda().planContinueProcessOperation(this.execution);
    }

    protected void cleanupCompensation() {
        this.commandContext.getHistoryManager().recordActivityEnd(this.execution, null);
        this.commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(this.execution, null);
        ExecutionEntity parentExecutionEntity = this.execution.getParent();
        if (parentExecutionEntity.isScope() && !parentExecutionEntity.isProcessInstanceType() && this.allChildExecutionsEnded(parentExecutionEntity, null)) {
            ExecutionEntity executionEntityToEnd = parentExecutionEntity;
            ExecutionEntity scopeExecutionEntity = this.findNextParentScopeExecutionWithAllEndedChildExecutions(parentExecutionEntity, parentExecutionEntity);
            while (scopeExecutionEntity != null) {
                executionEntityToEnd = scopeExecutionEntity;
                scopeExecutionEntity = this.findNextParentScopeExecutionWithAllEndedChildExecutions(scopeExecutionEntity, parentExecutionEntity);
            }
            if (executionEntityToEnd.isProcessInstanceType()) {
                Context.getAgenda().planEndExecutionOperation(executionEntityToEnd);
            } else {
                Context.getAgenda().planDestroyScopeOperation(executionEntityToEnd);
            }
        }
    }

    protected void cleanupExecutions(FlowElement currentFlowElement) {
        Activity activity;
        if (this.execution.getParentId() != null && this.execution.isScope()) {
            Context.getAgenda().planDestroyScopeOperation(this.execution);
        } else if (currentFlowElement instanceof Activity && CollectionUtil.isNotEmpty((activity = (Activity)currentFlowElement).getBoundaryEvents())) {
            ArrayList<String> notToDeleteEvents = new ArrayList<String>();
            for (BoundaryEvent event : activity.getBoundaryEvents()) {
                if (!CollectionUtil.isNotEmpty(event.getEventDefinitions()) || !(event.getEventDefinitions().get(0) instanceof CancelEventDefinition)) continue;
                notToDeleteEvents.add(event.getId());
            }
            List<ExecutionEntity> childExecutions = this.commandContext.getExecutionEntityManager().findChildExecutionsByParentExecutionId(this.execution.getId());
            for (ExecutionEntity childExecution : childExecutions) {
                if (childExecution.getCurrentFlowElement() != null && notToDeleteEvents.contains(childExecution.getCurrentFlowElement().getId())) continue;
                this.commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(childExecution, null);
            }
        }
    }

    protected ExecutionEntity findNextParentScopeExecutionWithAllEndedChildExecutions(ExecutionEntity executionEntity, ExecutionEntity executionEntityToIgnore) {
        if (executionEntity.getParentId() != null) {
            ExecutionEntity scopeExecutionEntity = executionEntity.getParent();
            while (!scopeExecutionEntity.isScope() || !scopeExecutionEntity.isProcessInstanceType()) {
                scopeExecutionEntity = scopeExecutionEntity.getParent();
            }
            if (this.allChildExecutionsEnded(scopeExecutionEntity, executionEntityToIgnore)) {
                return scopeExecutionEntity;
            }
        }
        return null;
    }

    protected boolean allChildExecutionsEnded(ExecutionEntity parentExecutionEntity, ExecutionEntity executionEntityToIgnore) {
        for (ExecutionEntity executionEntity : parentExecutionEntity.getExecutions()) {
            if (executionEntityToIgnore != null && executionEntityToIgnore.getId().equals(executionEntity.getId())) continue;
            if (!executionEntity.isEnded()) {
                return false;
            }
            if (executionEntity.getExecutions() == null || executionEntity.getExecutions().size() <= 0 || this.allChildExecutionsEnded(executionEntity, executionEntityToIgnore)) continue;
            return false;
        }
        return true;
    }

    private void handleBoundaryEvent(FlowNode flowNode) {
        BoundaryEvent event;
        Activity activity;
        if (flowNode instanceof BoundaryEvent && CollectionUtil.isNotEmpty((activity = (event = (BoundaryEvent)flowNode).getAttachedToRef()).getExecutionListeners())) {
            this.executeExecutionListeners((HasExecutionListeners)activity, "end");
        }
    }
}

