/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;

public class GetTaskVariablesCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Collection<String> variableNames;
    protected boolean isLocal;

    public GetTaskVariablesCmd(String taskId, Collection<String> variableNames, boolean isLocal) {
        this.taskId = taskId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ActivitiIllegalArgumentException("taskId is null");
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (task == null) {
            throw new ActivitiObjectNotFoundException("task " + this.taskId + " doesn't exist", Task.class);
        }
        if (this.variableNames == null) {
            if (this.isLocal) {
                return task.getVariablesLocal();
            }
            return task.getVariables();
        }
        if (this.isLocal) {
            return task.getVariablesLocal(this.variableNames, false);
        }
        return task.getVariables(this.variableNames, false);
    }
}

