/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.Optional;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.factory.MessageExecutionContext;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ThrowMessage;
import org.activiti.engine.impl.delegate.ThrowMessageDelegate;
import org.activiti.engine.impl.delegate.invocation.ThrowMessageDelegateInvocation;

public abstract class AbstractThrowMessageEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    private final MessageEventDefinition messageEventDefinition;
    private final ThrowMessageDelegate delegate;
    private final MessageExecutionContext messageExecutionContext;

    public AbstractThrowMessageEventActivityBehavior(MessageEventDefinition messageEventDefinition, ThrowMessageDelegate delegate, MessageExecutionContext messageExecutionContext) {
        this.messageEventDefinition = messageEventDefinition;
        this.delegate = delegate;
        this.messageExecutionContext = messageExecutionContext;
    }

    protected boolean send(DelegateExecution execution, ThrowMessage message) {
        ThrowMessageDelegateInvocation invocation = new ThrowMessageDelegateInvocation(this.delegate, execution, message);
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
        return (Boolean)invocation.getInvocationResult();
    }

    @Override
    public void execute(DelegateExecution execution) {
        ThrowMessage throwMessage = this.getThrowMessage(execution);
        boolean isSent = this.send(execution, throwMessage);
        if (isSent) {
            this.dispatchEvent(execution, throwMessage);
        }
        super.execute(execution);
    }

    public MessageEventDefinition getMessageEventDefinition() {
        return this.messageEventDefinition;
    }

    protected ThrowMessage getThrowMessage(DelegateExecution execution) {
        return this.messageExecutionContext.createThrowMessage(execution);
    }

    protected void dispatchEvent(DelegateExecution execution, ThrowMessage throwMessage) {
        Optional.ofNullable(Context.getCommandContext()).filter(commandContext -> commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()).ifPresent(commandContext -> {
            String messageName = throwMessage.getName();
            String correlationKey = throwMessage.getCorrelationKey().orElse(null);
            Object payload = throwMessage.getPayload().orElse(null);
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createMessageSentEvent(execution, messageName, correlationKey, payload));
        });
    }

    public ThrowMessageDelegate getDelegate() {
        return this.delegate;
    }

    public MessageExecutionContext getMessageExecutionContext() {
        return this.messageExecutionContext;
    }
}

