/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.asyncexecutor.FindExpiredJobsCmd;
import org.activiti.engine.impl.asyncexecutor.ResetExpiredJobsCmd;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetExpiredJobsRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ResetExpiredJobsRunnable.class);
    protected final AsyncExecutor asyncExecutor;
    protected volatile boolean isInterrupted;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    public ResetExpiredJobsRunnable(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        log.info("{} starting to reset expired jobs");
        Thread.currentThread().setName("activiti-reset-expired-jobs");
        while (!this.isInterrupted) {
            try {
                List<JobEntity> expiredJobs = this.asyncExecutor.getProcessEngineConfiguration().getCommandExecutor().execute(new FindExpiredJobsCmd(this.asyncExecutor.getResetExpiredJobsPageSize()));
                ArrayList<String> expiredJobIds = new ArrayList<String>(expiredJobs.size());
                for (JobEntity expiredJob : expiredJobs) {
                    expiredJobIds.add(expiredJob.getId());
                }
                if (expiredJobIds.size() > 0) {
                    this.asyncExecutor.getProcessEngineConfiguration().getCommandExecutor().execute(new ResetExpiredJobsCmd(expiredJobIds));
                }
            }
            catch (Throwable e) {
                if (e instanceof ActivitiOptimisticLockingException) {
                    log.debug("Optmistic lock exception while resetting locked jobs", e);
                }
                log.error("exception during resetting expired jobs", (Object)e.getMessage(), (Object)e);
            }
            try {
                Object e = this.MONITOR;
                synchronized (e) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(this.asyncExecutor.getResetExpiredJobsInterval());
                    }
                }
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("async reset expired jobs wait interrupted");
            }
            finally {
                this.isWaiting.set(false);
            }
        }
        log.info("{} stopped resetting expired jobs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }
}

