/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ValueExpression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.activiti.core.el.ActivitiElContext;
import org.activiti.core.el.CustomFunctionProvider;
import org.activiti.core.el.ELContextBuilder;
import org.activiti.core.el.ELResolverReflectionBlockerDecorator;
import org.activiti.core.el.ReadOnlyMapELResolver;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.data.ItemInstance;
import org.activiti.engine.impl.el.CustomMapperJsonNodeELResolver;
import org.activiti.engine.impl.el.DynamicBeanPropertyELResolver;
import org.activiti.engine.impl.el.JuelExpression;
import org.activiti.engine.impl.el.VariableScopeElResolver;
import org.activiti.engine.impl.persistence.entity.VariableScopeImpl;

public class ExpressionManager {
    protected ExpressionFactory expressionFactory;
    protected Map<Object, Object> beans;
    protected List<CustomFunctionProvider> customFunctionProviders;

    public ExpressionManager() {
        this(null);
    }

    public ExpressionManager(boolean initFactory) {
        this(null, initFactory);
    }

    public ExpressionManager(Map<Object, Object> beans) {
        this(beans, true);
    }

    public ExpressionManager(Map<Object, Object> beans, boolean initFactory) {
        if (initFactory) {
            this.expressionFactory = ExpressionFactory.newInstance();
        }
        this.beans = beans;
    }

    public Expression createExpression(String expression) {
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.getElContext(Collections.emptyMap()), expression.trim(), Object.class);
        return new JuelExpression(valueExpression, expression);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public List<CustomFunctionProvider> getCustomFunctionProviders() {
        return this.customFunctionProviders;
    }

    public void setCustomFunctionProviders(List<CustomFunctionProvider> customFunctionProviders) {
        this.customFunctionProviders = customFunctionProviders;
    }

    public ELContext getElContext(VariableScope variableScope) {
        ELContext elContext = null;
        if (variableScope instanceof VariableScopeImpl) {
            VariableScopeImpl variableScopeImpl = (VariableScopeImpl)variableScope;
            elContext = variableScopeImpl.getCachedElContext();
        }
        if (elContext == null) {
            elContext = this.createElContext(variableScope);
            if (variableScope instanceof VariableScopeImpl) {
                ((VariableScopeImpl)variableScope).setCachedElContext(elContext);
            }
        }
        return elContext;
    }

    protected ActivitiElContext createElContext(VariableScope variableScope) {
        return (ActivitiElContext)new ELContextBuilder().withResolvers(new ELResolver[]{this.createElResolver(variableScope)}).buildWithCustomFunctions(this.customFunctionProviders);
    }

    protected ELResolver createElResolver(VariableScope variableScope) {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add((ELResolver)new VariableScopeElResolver(variableScope));
        this.addBeansResolver(elResolver);
        this.addBaseResolvers(elResolver);
        return elResolver;
    }

    protected void addBeansResolver(CompositeELResolver elResolver) {
        if (this.beans != null) {
            elResolver.add((ELResolver)new ReadOnlyMapELResolver(this.beans));
        }
    }

    private void addBaseResolvers(CompositeELResolver elResolver) {
        elResolver.add((ELResolver)new ArrayELResolver());
        elResolver.add((ELResolver)new ListELResolver());
        elResolver.add((ELResolver)new MapELResolver());
        elResolver.add((ELResolver)new CustomMapperJsonNodeELResolver());
        elResolver.add((ELResolver)new DynamicBeanPropertyELResolver(ItemInstance.class, "getFieldValue", "setFieldValue"));
        elResolver.add((ELResolver)new ELResolverReflectionBlockerDecorator((ELResolver)new BeanELResolver()));
    }

    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    public void setBeans(Map<Object, Object> beans) {
        this.beans = beans;
    }

    public ELContext getElContext(Map<String, Object> availableVariables) {
        CompositeELResolver elResolver = new CompositeELResolver();
        this.addBaseResolvers(elResolver);
        return new ELContextBuilder().withResolvers(new ELResolver[]{elResolver}).withVariables(availableVariables).buildWithCustomFunctions(this.customFunctionProviders);
    }
}

