/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.DataStore;
import org.activiti.bpmn.model.Error;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.Import;
import org.activiti.bpmn.model.Interface;
import org.activiti.bpmn.model.ItemDefinition;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.MessageFlow;
import org.activiti.bpmn.model.Pool;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.Resource;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.apache.commons.lang3.StringUtils;

public class BpmnModel {
    protected Map<String, List<ExtensionAttribute>> definitionsAttributes = new LinkedHashMap<String, List<ExtensionAttribute>>();
    protected List<Process> processes = new ArrayList<Process>();
    protected Map<String, GraphicInfo> locationMap = new LinkedHashMap<String, GraphicInfo>();
    protected Map<String, GraphicInfo> labelLocationMap = new LinkedHashMap<String, GraphicInfo>();
    protected Map<String, List<GraphicInfo>> flowLocationMap = new LinkedHashMap<String, List<GraphicInfo>>();
    protected List<Signal> signals = new ArrayList<Signal>();
    protected Map<String, MessageFlow> messageFlowMap = new LinkedHashMap<String, MessageFlow>();
    protected Map<String, Message> messageMap = new LinkedHashMap<String, Message>();
    protected Map<String, Error> errorMap = new LinkedHashMap<String, Error>();
    protected Map<String, ItemDefinition> itemDefinitionMap = new LinkedHashMap<String, ItemDefinition>();
    protected Map<String, DataStore> dataStoreMap = new LinkedHashMap<String, DataStore>();
    protected List<Pool> pools = new ArrayList<Pool>();
    protected List<Import> imports = new ArrayList<Import>();
    protected List<Interface> interfaces = new ArrayList<Interface>();
    protected List<Artifact> globalArtifacts = new ArrayList<Artifact>();
    protected List<Resource> resources = new ArrayList<Resource>();
    protected Map<String, String> namespaceMap = new LinkedHashMap<String, String>();
    protected String targetNamespace;
    protected String sourceSystemId;
    protected List<String> userTaskFormTypes;
    protected List<String> startEventFormTypes;
    protected int nextFlowIdCounter = 1;
    protected Object eventSupport;

    public Map<String, List<ExtensionAttribute>> getDefinitionsAttributes() {
        return this.definitionsAttributes;
    }

    public String getDefinitionsAttributeValue(String namespace, String name) {
        List<ExtensionAttribute> attributes = this.getDefinitionsAttributes().get(name);
        if (attributes != null && !attributes.isEmpty()) {
            for (ExtensionAttribute attribute : attributes) {
                if (!namespace.equals(attribute.getNamespace())) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public void addDefinitionsAttribute(ExtensionAttribute attribute) {
        if (attribute != null && StringUtils.isNotEmpty((CharSequence)attribute.getName())) {
            ArrayList attributeList = null;
            if (!this.definitionsAttributes.containsKey(attribute.getName())) {
                attributeList = new ArrayList();
                this.definitionsAttributes.put(attribute.getName(), attributeList);
            }
            this.definitionsAttributes.get(attribute.getName()).add(attribute);
        }
    }

    public void setDefinitionsAttributes(Map<String, List<ExtensionAttribute>> attributes) {
        this.definitionsAttributes = attributes;
    }

    public Process getMainProcess() {
        if (!this.getPools().isEmpty()) {
            return this.getProcess(this.getPools().get(0).getId());
        }
        return this.getProcess(null);
    }

    public Process getProcess(String poolRef) {
        for (Process process : this.processes) {
            boolean foundPool = false;
            for (Pool pool : this.pools) {
                if (!StringUtils.isNotEmpty((CharSequence)pool.getProcessRef()) || !pool.getProcessRef().equalsIgnoreCase(process.getId())) continue;
                if (poolRef != null) {
                    if (!pool.getId().equalsIgnoreCase(poolRef)) continue;
                    foundPool = true;
                    continue;
                }
                foundPool = true;
            }
            if (poolRef == null && !foundPool) {
                return process;
            }
            if (poolRef == null || !foundPool) continue;
            return process;
        }
        return null;
    }

    public Process getProcessById(String id) {
        for (Process process : this.processes) {
            if (!process.getId().equals(id)) continue;
            return process;
        }
        return null;
    }

    public List<Process> getProcesses() {
        return this.processes;
    }

    public void addProcess(Process process) {
        this.processes.add(process);
    }

    public Pool getPool(String id) {
        Pool foundPool = null;
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            for (Pool pool : this.pools) {
                if (!id.equals(pool.getId())) continue;
                foundPool = pool;
                break;
            }
        }
        return foundPool;
    }

    public Lane getLane(String id) {
        Lane foundLane = null;
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            for (Process process : this.processes) {
                for (Lane lane : process.getLanes()) {
                    if (!id.equals(lane.getId())) continue;
                    foundLane = lane;
                    break;
                }
                if (foundLane == null) continue;
                break;
            }
        }
        return foundLane;
    }

    public FlowElement getFlowElement(String id) {
        Process process2;
        FlowElement foundFlowElement = null;
        Iterator<Process> iterator = this.processes.iterator();
        while (iterator.hasNext() && (foundFlowElement = (process2 = iterator.next()).getFlowElement(id)) == null) {
        }
        if (foundFlowElement == null) {
            for (Process process2 : this.processes) {
                FlowElement flowElement;
                Iterator<SubProcess> iterator2 = process2.findFlowElementsOfType(SubProcess.class).iterator();
                while (iterator2.hasNext() && (foundFlowElement = this.getFlowElementInSubProcess(id, (SubProcess)(flowElement = (FlowElement)iterator2.next()))) == null) {
                }
                if (foundFlowElement == null) continue;
                break;
            }
        }
        return foundFlowElement;
    }

    protected FlowElement getFlowElementInSubProcess(String id, SubProcess subProcess) {
        FlowElement foundFlowElement;
        block1: {
            foundFlowElement = subProcess.getFlowElement(id);
            if (foundFlowElement != null) break block1;
            for (FlowElement flowElement : subProcess.getFlowElements()) {
                if (flowElement instanceof SubProcess && (foundFlowElement = this.getFlowElementInSubProcess(id, (SubProcess)flowElement)) != null) break;
            }
        }
        return foundFlowElement;
    }

    public Artifact getArtifact(String id) {
        Process process2;
        Artifact foundArtifact = null;
        Iterator<Process> iterator = this.processes.iterator();
        while (iterator.hasNext() && (foundArtifact = (process2 = iterator.next()).getArtifact(id)) == null) {
        }
        if (foundArtifact == null) {
            for (Process process2 : this.processes) {
                FlowElement flowElement;
                Iterator<SubProcess> iterator2 = process2.findFlowElementsOfType(SubProcess.class).iterator();
                while (iterator2.hasNext() && (foundArtifact = this.getArtifactInSubProcess(id, (SubProcess)(flowElement = (FlowElement)iterator2.next()))) == null) {
                }
                if (foundArtifact == null) continue;
                break;
            }
        }
        return foundArtifact;
    }

    protected Artifact getArtifactInSubProcess(String id, SubProcess subProcess) {
        Artifact foundArtifact;
        block1: {
            foundArtifact = subProcess.getArtifact(id);
            if (foundArtifact != null) break block1;
            for (FlowElement flowElement : subProcess.getFlowElements()) {
                if (flowElement instanceof SubProcess && (foundArtifact = this.getArtifactInSubProcess(id, (SubProcess)flowElement)) != null) break;
            }
        }
        return foundArtifact;
    }

    public void addGraphicInfo(String key, GraphicInfo graphicInfo) {
        this.locationMap.put(key, graphicInfo);
    }

    public GraphicInfo getGraphicInfo(String key) {
        return this.locationMap.get(key);
    }

    public void removeGraphicInfo(String key) {
        this.locationMap.remove(key);
    }

    public List<GraphicInfo> getFlowLocationGraphicInfo(String key) {
        return this.flowLocationMap.get(key);
    }

    public void removeFlowGraphicInfoList(String key) {
        this.flowLocationMap.remove(key);
    }

    public Map<String, GraphicInfo> getLocationMap() {
        return this.locationMap;
    }

    public boolean hasDiagramInterchangeInfo() {
        return !this.locationMap.isEmpty();
    }

    public Map<String, List<GraphicInfo>> getFlowLocationMap() {
        return this.flowLocationMap;
    }

    public GraphicInfo getLabelGraphicInfo(String key) {
        return this.labelLocationMap.get(key);
    }

    public void addLabelGraphicInfo(String key, GraphicInfo graphicInfo) {
        this.labelLocationMap.put(key, graphicInfo);
    }

    public void removeLabelGraphicInfo(String key) {
        this.labelLocationMap.remove(key);
    }

    public Map<String, GraphicInfo> getLabelLocationMap() {
        return this.labelLocationMap;
    }

    public void addFlowGraphicInfoList(String key, List<GraphicInfo> graphicInfoList) {
        this.flowLocationMap.put(key, graphicInfoList);
    }

    public Collection<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<Resource> resourceList) {
        if (resourceList != null) {
            this.resources.clear();
            this.resources.addAll(resourceList);
        }
    }

    public void addResource(Resource resource) {
        if (resource != null) {
            this.resources.add(resource);
        }
    }

    public boolean containsResourceId(String resourceId) {
        return this.getResource(resourceId) != null;
    }

    public Resource getResource(String id) {
        for (Resource resource : this.resources) {
            if (!id.equals(resource.getId())) continue;
            return resource;
        }
        return null;
    }

    public Collection<Signal> getSignals() {
        return this.signals;
    }

    public void setSignals(Collection<Signal> signalList) {
        if (signalList != null) {
            this.signals.clear();
            this.signals.addAll(signalList);
        }
    }

    public void addSignal(Signal signal) {
        if (signal != null) {
            this.signals.add(signal);
        }
    }

    public boolean containsSignalId(String signalId) {
        return this.getSignal(signalId) != null;
    }

    public Signal getSignal(String id) {
        for (Signal signal : this.signals) {
            if (!id.equals(signal.getId())) continue;
            return signal;
        }
        return null;
    }

    public Map<String, MessageFlow> getMessageFlows() {
        return this.messageFlowMap;
    }

    public void setMessageFlows(Map<String, MessageFlow> messageFlows) {
        this.messageFlowMap = messageFlows;
    }

    public void addMessageFlow(MessageFlow messageFlow) {
        if (messageFlow != null && StringUtils.isNotEmpty((CharSequence)messageFlow.getId())) {
            this.messageFlowMap.put(messageFlow.getId(), messageFlow);
        }
    }

    public MessageFlow getMessageFlow(String id) {
        return this.messageFlowMap.get(id);
    }

    public boolean containsMessageFlowId(String messageFlowId) {
        return this.messageFlowMap.containsKey(messageFlowId);
    }

    public Collection<Message> getMessages() {
        return this.messageMap.values();
    }

    public void setMessages(Collection<Message> messageList) {
        if (messageList != null) {
            this.messageMap.clear();
            for (Message message : messageList) {
                this.addMessage(message);
            }
        }
    }

    public void addMessage(Message message) {
        if (message != null && StringUtils.isNotEmpty((CharSequence)message.getId())) {
            this.messageMap.put(message.getId(), message);
        }
    }

    public Message getMessage(String id) {
        int indexOfNS;
        Message result = this.messageMap.get(id);
        if (result == null && (indexOfNS = id.indexOf(":")) > 0) {
            String idNamespace = id.substring(0, indexOfNS);
            if (idNamespace.equalsIgnoreCase(this.getTargetNamespace())) {
                id = id.substring(indexOfNS + 1);
            }
            result = this.messageMap.get(id);
        }
        return result;
    }

    public boolean containsMessageId(String messageId) {
        return this.messageMap.containsKey(messageId);
    }

    public Map<String, Error> getErrors() {
        return this.errorMap;
    }

    public void setErrors(Map<String, Error> errorMap) {
        this.errorMap = errorMap;
    }

    public void addError(String errorRef, String errorName, String errorCode) {
        if (StringUtils.isNotEmpty((CharSequence)errorRef)) {
            this.errorMap.put(errorRef, new Error(errorRef, errorName, errorCode));
        }
    }

    public boolean containsErrorRef(String errorRef) {
        return this.errorMap.containsKey(errorRef);
    }

    public String getErrorCode(String errorRef) {
        if (errorRef == null) {
            return null;
        }
        Error error = this.errorMap.get(errorRef);
        return error != null ? error.getErrorCode() : null;
    }

    public Map<String, ItemDefinition> getItemDefinitions() {
        return this.itemDefinitionMap;
    }

    public void setItemDefinitions(Map<String, ItemDefinition> itemDefinitionMap) {
        this.itemDefinitionMap = itemDefinitionMap;
    }

    public void addItemDefinition(String id, ItemDefinition item) {
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            this.itemDefinitionMap.put(id, item);
        }
    }

    public boolean containsItemDefinitionId(String id) {
        return this.itemDefinitionMap.containsKey(id);
    }

    public Map<String, DataStore> getDataStores() {
        return this.dataStoreMap;
    }

    public void setDataStores(Map<String, DataStore> dataStoreMap) {
        this.dataStoreMap = dataStoreMap;
    }

    public DataStore getDataStore(String id) {
        DataStore dataStore = null;
        if (this.dataStoreMap.containsKey(id)) {
            dataStore = this.dataStoreMap.get(id);
        }
        return dataStore;
    }

    public void addDataStore(String id, DataStore dataStore) {
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            this.dataStoreMap.put(id, dataStore);
        }
    }

    public boolean containsDataStore(String id) {
        return this.dataStoreMap.containsKey(id);
    }

    public List<Pool> getPools() {
        return this.pools;
    }

    public void setPools(List<Pool> pools) {
        this.pools = pools;
    }

    public List<Import> getImports() {
        return this.imports;
    }

    public void setImports(List<Import> imports) {
        this.imports = imports;
    }

    public List<Interface> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<Interface> interfaces) {
        this.interfaces = interfaces;
    }

    public List<Artifact> getGlobalArtifacts() {
        return this.globalArtifacts;
    }

    public void setGlobalArtifacts(List<Artifact> globalArtifacts) {
        this.globalArtifacts = globalArtifacts;
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaceMap.put(prefix, uri);
    }

    public boolean containsNamespacePrefix(String prefix) {
        return this.namespaceMap.containsKey(prefix);
    }

    public String getNamespace(String prefix) {
        return this.namespaceMap.get(prefix);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaceMap;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public List<String> getUserTaskFormTypes() {
        return this.userTaskFormTypes;
    }

    public void setUserTaskFormTypes(List<String> userTaskFormTypes) {
        this.userTaskFormTypes = userTaskFormTypes;
    }

    public List<String> getStartEventFormTypes() {
        return this.startEventFormTypes;
    }

    public void setStartEventFormTypes(List<String> startEventFormTypes) {
        this.startEventFormTypes = startEventFormTypes;
    }

    @JsonIgnore
    public Object getEventSupport() {
        return this.eventSupport;
    }

    public void setEventSupport(Object eventSupport) {
        this.eventSupport = eventSupport;
    }

    public String getStartFormKey(String processId) {
        FlowElement initialFlowElement = this.getProcessById(processId).getInitialFlowElement();
        if (initialFlowElement instanceof StartEvent) {
            StartEvent startEvent = (StartEvent)initialFlowElement;
            return startEvent.getFormKey();
        }
        return null;
    }
}

