/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;

public class Message
extends BaseElement {
    protected String name;
    protected String itemRef;

    private Message(Builder builder) {
        this.id = builder.id;
        this.xmlRowNumber = builder.xmlRowNumber;
        this.xmlColumnNumber = builder.xmlColumnNumber;
        this.extensionElements = builder.extensionElements;
        this.attributes = builder.attributes;
        this.name = builder.name;
        this.itemRef = builder.itemRef;
    }

    public Message() {
    }

    public Message(String id, String name, String itemRef) {
        this.id = id;
        this.name = name;
        this.itemRef = itemRef;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getItemRef() {
        return this.itemRef;
    }

    public void setItemRef(String itemRef) {
        this.itemRef = itemRef;
    }

    @Override
    public Message clone() {
        Message clone = new Message();
        clone.setValues(this);
        return clone;
    }

    public void setValues(Message otherElement) {
        super.setValues(otherElement);
        this.setName(otherElement.getName());
        this.setItemRef(otherElement.getItemRef());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(Message message) {
        return new Builder(message);
    }

    public static final class Builder {
        private String id;
        private int xmlRowNumber;
        private int xmlColumnNumber;
        private Map<String, List<ExtensionElement>> extensionElements = Collections.emptyMap();
        private Map<String, List<ExtensionAttribute>> attributes = Collections.emptyMap();
        private String name;
        private String itemRef;

        private Builder() {
        }

        private Builder(Message message) {
            this.id = message.id;
            this.xmlRowNumber = message.xmlRowNumber;
            this.xmlColumnNumber = message.xmlColumnNumber;
            this.extensionElements = message.extensionElements;
            this.attributes = message.attributes;
            this.name = message.name;
            this.itemRef = message.itemRef;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder xmlRowNumber(int xmlRowNumber) {
            this.xmlRowNumber = xmlRowNumber;
            return this;
        }

        public Builder xmlColumnNumber(int xmlColumnNumber) {
            this.xmlColumnNumber = xmlColumnNumber;
            return this;
        }

        public Builder extensionElements(Map<String, List<ExtensionElement>> extensionElements) {
            this.extensionElements = extensionElements;
            return this;
        }

        public Builder attributes(Map<String, List<ExtensionAttribute>> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder itemRef(String itemRef) {
            this.itemRef = itemRef;
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }
}

