/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.HasExtensionAttributes;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseElement
implements HasExtensionAttributes {
    protected String id;
    protected int xmlRowNumber;
    protected int xmlColumnNumber;
    protected Map<String, List<ExtensionElement>> extensionElements = new LinkedHashMap<String, List<ExtensionElement>>();
    protected Map<String, List<ExtensionAttribute>> attributes = new LinkedHashMap<String, List<ExtensionAttribute>>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getXmlRowNumber() {
        return this.xmlRowNumber;
    }

    public void setXmlRowNumber(int xmlRowNumber) {
        this.xmlRowNumber = xmlRowNumber;
    }

    public int getXmlColumnNumber() {
        return this.xmlColumnNumber;
    }

    public void setXmlColumnNumber(int xmlColumnNumber) {
        this.xmlColumnNumber = xmlColumnNumber;
    }

    public Map<String, List<ExtensionElement>> getExtensionElements() {
        return this.extensionElements;
    }

    public void addExtensionElement(ExtensionElement extensionElement) {
        if (extensionElement != null && StringUtils.isNotEmpty((CharSequence)extensionElement.getName())) {
            this.extensionElements.computeIfAbsent(extensionElement.getName(), k -> new ArrayList());
            this.extensionElements.get(extensionElement.getName()).add(extensionElement);
        }
    }

    public void setExtensionElements(Map<String, List<ExtensionElement>> extensionElements) {
        this.extensionElements = extensionElements;
    }

    @Override
    public Map<String, List<ExtensionAttribute>> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getAttributeValue(String namespace, String name) {
        return Optional.ofNullable(this.getAttributes()).map(map -> (List)map.get(name)).orElse(Collections.emptyList()).stream().filter(e -> this.isNamespaceMatching(namespace, (ExtensionAttribute)e)).findFirst().map(ExtensionAttribute::getValue).orElse(null);
    }

    private boolean isNamespaceMatching(String namespace, ExtensionAttribute attribute) {
        return namespace == null && attribute.getNamespace() == null || namespace != null && namespace.equals(attribute.getNamespace());
    }

    @Override
    public void addAttribute(ExtensionAttribute attribute) {
        if (attribute != null && StringUtils.isNotEmpty((CharSequence)attribute.getName())) {
            this.attributes.computeIfAbsent(attribute.getName(), key -> new ArrayList());
            this.attributes.get(attribute.getName()).add(attribute);
        }
    }

    @Override
    public void setAttributes(Map<String, List<ExtensionAttribute>> attributes) {
        this.attributes = attributes;
    }

    public void setValues(BaseElement otherElement) {
        this.setId(otherElement.getId());
        if (otherElement.getExtensionElements() != null && !otherElement.getExtensionElements().isEmpty()) {
            Map<String, List> validExtensionElements = otherElement.getExtensionElements().entrySet().stream().filter(e -> this.hasElements((List)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.extensionElements.putAll(validExtensionElements);
        }
        if (otherElement.getAttributes() != null && !otherElement.getAttributes().isEmpty()) {
            Map<String, List> validAttributes = otherElement.getAttributes().entrySet().stream().filter(e -> this.hasElements((List)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.attributes.putAll(validAttributes);
        }
    }

    private boolean hasElements(List<?> listOfElements) {
        return listOfElements != null && !listOfElements.isEmpty();
    }

    public abstract BaseElement clone();
}

