/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.Process;
import org.apache.commons.lang3.StringUtils;

public class LaneExport
implements BpmnXMLConstants {
    public static void writeLanes(Process process, XMLStreamWriter xtw) throws Exception {
        if (!process.getLanes().isEmpty()) {
            xtw.writeStartElement("bpmn2", "laneSet", "http://www.omg.org/spec/BPMN/20100524/MODEL");
            xtw.writeAttribute("id", "laneSet_" + process.getId());
            for (Lane lane : process.getLanes()) {
                boolean didWriteExtensionStartElement;
                xtw.writeStartElement("bpmn2", "lane", "http://www.omg.org/spec/BPMN/20100524/MODEL");
                xtw.writeAttribute("id", lane.getId());
                if (StringUtils.isNotEmpty((CharSequence)lane.getName())) {
                    xtw.writeAttribute("name", lane.getName());
                }
                if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)lane, false, xtw)) {
                    xtw.writeEndElement();
                }
                for (String flowNodeRef : lane.getFlowReferences()) {
                    xtw.writeStartElement("bpmn2", "flowNodeRef", "http://www.omg.org/spec/BPMN/20100524/MODEL");
                    xtw.writeCharacters(flowNodeRef);
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }
}

