/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.apache.commons.lang3.StringUtils;

public class MultiInstanceExport
implements BpmnXMLConstants {
    public static void writeMultiInstance(Activity activity, XMLStreamWriter xtw) throws Exception {
        if (activity == null || activity.getLoopCharacteristics() == null) {
            return;
        }
        MultiInstanceLoopCharacteristics multiInstanceObject = activity.getLoopCharacteristics();
        xtw.writeStartElement("bpmn2", "multiInstanceLoopCharacteristics", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        BpmnXMLUtil.writeDefaultAttribute("isSequential", String.valueOf(multiInstanceObject.isSequential()).toLowerCase(), xtw);
        MultiInstanceExport.writeAttributeIfNotEmpty("collection", multiInstanceObject.getInputDataItem(), xtw);
        MultiInstanceExport.writeAttributeIfNotEmpty("elementVariable", multiInstanceObject.getElementVariable(), xtw);
        MultiInstanceExport.writeAttributeIfNotEmpty("elementIndexVariable", multiInstanceObject.getElementIndexVariable(), xtw);
        MultiInstanceExport.writeElementIfNotEmpty("loopCardinality", multiInstanceObject.getLoopCardinality(), xtw);
        MultiInstanceExport.writeElementIfNotEmpty("loopDataOutputRef", multiInstanceObject.getLoopDataOutputRef(), xtw);
        if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getOutputDataItem())) {
            xtw.writeStartElement("bpmn2", "outputDataItem", "http://www.omg.org/spec/BPMN/20100524/MODEL");
            xtw.writeAttribute("name", multiInstanceObject.getOutputDataItem());
            xtw.writeEndElement();
        }
        MultiInstanceExport.writeElementIfNotEmpty("completionCondition", multiInstanceObject.getCompletionCondition(), xtw);
        xtw.writeEndElement();
    }

    private static void writeAttributeIfNotEmpty(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            BpmnXMLUtil.writeQualifiedAttribute(attributeName, value, xtw);
        }
    }

    private static void writeElementIfNotEmpty(String elementName, String value, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            xtw.writeStartElement("bpmn2", elementName, "http://www.omg.org/spec/BPMN/20100524/MODEL");
            xtw.writeCharacters(value);
            xtw.writeEndElement();
        }
    }
}

