/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.time.DateTimeException;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.activiti.api.task.model.payloads.CreateTaskVariablePayload;
import org.activiti.api.task.model.payloads.UpdateTaskVariablePayload;
import org.activiti.common.util.DateFormatterProvider;
import org.activiti.runtime.api.impl.VariableNameValidator;

public class TaskVariablesPayloadValidator {
    private final DateFormatterProvider dateFormatterProvider;
    private final VariableNameValidator variableNameValidator;

    public TaskVariablesPayloadValidator(DateFormatterProvider dateFormatterProvider, VariableNameValidator variableNameValidator) {
        this.dateFormatterProvider = dateFormatterProvider;
        this.variableNameValidator = variableNameValidator;
    }

    private Optional<Date> handleAsDate(String value) {
        try {
            return Optional.ofNullable(this.dateFormatterProvider.parse(value));
        }
        catch (DateTimeException e) {
            return Optional.empty();
        }
    }

    private void checkNotValidCharactersInVariableName(String name, String errorMsg) {
        if (!this.variableNameValidator.validate(name)) {
            throw new IllegalStateException(errorMsg + (name != null ? name : "null"));
        }
    }

    public CreateTaskVariablePayload handleCreateTaskVariablePayload(CreateTaskVariablePayload createTaskVariablePayload) {
        this.checkNotValidCharactersInVariableName(createTaskVariablePayload.getName(), "Variable has not a valid name: ");
        Object value = createTaskVariablePayload.getValue();
        if (value instanceof String) {
            this.handleAsDate((String)value).ifPresent(arg_0 -> ((CreateTaskVariablePayload)createTaskVariablePayload).setValue(arg_0));
        }
        return createTaskVariablePayload;
    }

    public UpdateTaskVariablePayload handleUpdateTaskVariablePayload(UpdateTaskVariablePayload updateTaskVariablePayload) {
        this.checkNotValidCharactersInVariableName(updateTaskVariablePayload.getName(), "You cannot update a variable with not a valid name: ");
        Object value = updateTaskVariablePayload.getValue();
        if (value instanceof String) {
            this.handleAsDate((String)value).ifPresent(arg_0 -> ((UpdateTaskVariablePayload)updateTaskVariablePayload).setValue(arg_0));
        }
        return updateTaskVariablePayload;
    }

    public Map<String, Object> handlePayloadVariables(Map<String, Object> variables) {
        if (variables != null) {
            Set mismatchedVars = this.variableNameValidator.validateVariables(variables);
            if (!mismatchedVars.isEmpty()) {
                throw new IllegalStateException("Variables have not valid names: " + String.join((CharSequence)", ", mismatchedVars));
            }
            this.handleStringVariablesAsDates(variables);
        }
        return variables;
    }

    private void handleStringVariablesAsDates(Map<String, Object> variables) {
        if (variables != null) {
            variables.entrySet().stream().filter(stringObjectEntry -> stringObjectEntry.getValue() instanceof String).forEach(stringObjectEntry -> this.handleAsDate((String)stringObjectEntry.getValue()).ifPresent(stringObjectEntry::setValue));
        }
    }
}

